/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.SwitchExpressionArm;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;
import com.strobel.decompiler.patterns.Role;

public class SwitchExpression
extends Expression {
    public static final SwitchExpression NULL = new NullSwitchExpression();
    public static final Role<SwitchExpressionArm> ARM_ROLE = new Role<SwitchExpressionArm>("SwitchExpressionArm", SwitchExpressionArm.class, SwitchExpressionArm.NULL);
    public static final Role<Expression> GOVERNING_EXPRESSION_ROLE = new Role<Expression>("GoverningExpression", Expression.class, Expression.NULL);

    public SwitchExpression() {
        super(-34);
    }

    public SwitchExpression(int offset) {
        super(offset);
    }

    public final Expression getGoverningExpression() {
        return this.getChildByRole(GOVERNING_EXPRESSION_ROLE);
    }

    public final void setGoverningExpression(Expression value) {
        this.setChildByRole(GOVERNING_EXPRESSION_ROLE, value);
    }

    public final AstNodeCollection<SwitchExpressionArm> getArms() {
        return this.getChildrenByRole(ARM_ROLE);
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitSwitchExpression(this, data);
    }

    @Override
    public boolean matches(INode other, Match match) {
        if (other instanceof SwitchExpression) {
            SwitchExpression otherStatement = (SwitchExpression)other;
            return !otherStatement.isNull() && this.getGoverningExpression().matches(otherStatement.getGoverningExpression(), match) && this.getArms().matches(otherStatement.getArms(), match);
        }
        return false;
    }

    private static final class NullSwitchExpression
    extends SwitchExpression {
        public NullSwitchExpression() {
            super(-34);
        }

        @Override
        public final boolean isNull() {
            return true;
        }

        @Override
        public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
            return null;
        }

        @Override
        public boolean matches(INode other, Match match) {
            return other == null || other.isNull();
        }
    }
}

