/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis.index;

import cuchaz.enigma.analysis.index.EntryIndex;
import cuchaz.enigma.analysis.index.JarIndex;
import cuchaz.enigma.analysis.index.JarIndexer;
import cuchaz.enigma.api.view.entry.ClassEntryView;
import cuchaz.enigma.api.view.index.InheritanceIndexView;
import cuchaz.enigma.translation.representation.entry.ClassDefEntry;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class InheritanceIndex
implements JarIndexer,
InheritanceIndexView {
    private final EntryIndex entryIndex;
    private final ConcurrentMap<ClassEntry, List<ClassEntry>> classParents = new ConcurrentHashMap<ClassEntry, List<ClassEntry>>();
    private final ConcurrentMap<ClassEntry, List<ClassEntry>> classChildren = new ConcurrentHashMap<ClassEntry, List<ClassEntry>>();

    public InheritanceIndex(EntryIndex entryIndex) {
        this.entryIndex = entryIndex;
    }

    @Override
    public void indexClass(ClassDefEntry classEntry) {
        if (classEntry.isJre()) {
            return;
        }
        ClassEntry superClass = classEntry.getSuperClass();
        if (superClass != null && !superClass.getName().equals("java/lang/Object")) {
            this.indexParent(classEntry, superClass);
        }
        for (ClassEntry interfaceEntry : classEntry.getInterfaces()) {
            this.indexParent(classEntry, interfaceEntry);
        }
    }

    private void indexParent(ClassEntry childEntry, ClassEntry parentEntry) {
        this.classParents.computeIfAbsent(childEntry, k -> new ArrayList()).add(parentEntry);
        JarIndex.synchronizedAdd(this.classChildren, parentEntry, childEntry);
    }

    public Collection<ClassEntry> getParents(ClassEntry classEntry) {
        return this.classParents.getOrDefault(classEntry, Collections.emptyList());
    }

    @Override
    public Collection<? extends ClassEntryView> getParents(ClassEntryView entry) {
        return this.getParents((ClassEntry)entry);
    }

    public Collection<ClassEntry> getChildren(ClassEntry classEntry) {
        return this.classChildren.getOrDefault(classEntry, Collections.emptyList());
    }

    @Override
    public Collection<? extends ClassEntryView> getChildren(ClassEntryView entry) {
        return this.getChildren((ClassEntry)entry);
    }

    public Collection<ClassEntry> getDescendants(ClassEntry classEntry) {
        HashSet<ClassEntry> descendants = new HashSet<ClassEntry>();
        LinkedList<ClassEntry> descendantQueue = new LinkedList<ClassEntry>();
        descendantQueue.push(classEntry);
        while (!descendantQueue.isEmpty()) {
            ClassEntry descendant = (ClassEntry)descendantQueue.pop();
            Collection<ClassEntry> children = this.getChildren(descendant);
            children.forEach(descendantQueue::push);
            descendants.addAll(children);
        }
        return descendants;
    }

    public Set<ClassEntry> getAncestors(ClassEntry classEntry) {
        HashSet<ClassEntry> ancestors = new HashSet<ClassEntry>();
        LinkedList<ClassEntry> ancestorQueue = new LinkedList<ClassEntry>();
        ancestorQueue.push(classEntry);
        while (!ancestorQueue.isEmpty()) {
            ClassEntry ancestor = (ClassEntry)ancestorQueue.pop();
            Collection<ClassEntry> parents = this.getParents(ancestor);
            parents.forEach(ancestorQueue::push);
            ancestors.addAll(parents);
        }
        return ancestors;
    }

    public Relation computeClassRelation(ClassEntry classEntry, ClassEntry potentialAncestor) {
        if (potentialAncestor.getName().equals("java/lang/Object")) {
            return Relation.RELATED;
        }
        if (!this.entryIndex.hasClass(classEntry)) {
            return Relation.UNKNOWN;
        }
        for (ClassEntry ancestor : this.getAncestors(classEntry)) {
            if (potentialAncestor.equals(ancestor)) {
                return Relation.RELATED;
            }
            if (this.entryIndex.hasClass(ancestor)) continue;
            return Relation.UNKNOWN;
        }
        return Relation.UNRELATED;
    }

    public boolean isParent(ClassEntry classEntry) {
        return this.classChildren.containsKey(classEntry);
    }

    public boolean hasParents(ClassEntry classEntry) {
        Collection parents = (Collection)this.classParents.get(classEntry);
        return parents != null && !parents.isEmpty();
    }

    public static enum Relation {
        RELATED,
        UNRELATED,
        UNKNOWN;

    }
}

