/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.translation.mapping.serde.enigma;

import cuchaz.enigma.ProgressListener;
import cuchaz.enigma.translation.MappingTranslator;
import cuchaz.enigma.translation.mapping.AccessModifier;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.mapping.MappingDelta;
import cuchaz.enigma.translation.mapping.VoidEntryResolver;
import cuchaz.enigma.translation.mapping.serde.LfPrintWriter;
import cuchaz.enigma.translation.mapping.serde.MappingFileNameFormat;
import cuchaz.enigma.translation.mapping.serde.MappingHelper;
import cuchaz.enigma.translation.mapping.serde.MappingIoConverter;
import cuchaz.enigma.translation.mapping.serde.MappingSaveParameters;
import cuchaz.enigma.translation.mapping.tree.EntryTree;
import cuchaz.enigma.translation.mapping.tree.EntryTreeNode;
import cuchaz.enigma.translation.mapping.tree.HashEntryTree;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.translation.representation.entry.FieldEntry;
import cuchaz.enigma.translation.representation.entry.LocalVariableEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import cuchaz.enigma.utils.I18n;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.mappingio.MappingWriter;
import net.fabricmc.mappingio.format.MappingFormat;
import net.fabricmc.mappingio.tree.VisitOrder;
import net.fabricmc.mappingio.tree.VisitableMappingTree;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum EnigmaMappingsWriter {
    DIRECTORY{

        @Override
        @ApiStatus.Internal
        public void write(EntryTree<EntryMapping> mappings, MappingDelta<EntryMapping> delta, Path path, ProgressListener progress, MappingSaveParameters saveParameters, boolean useMio) {
            Collection<ClassEntry> changedClasses = delta.getChangedRoots().filter(entry -> entry instanceof ClassEntry).map(entry -> (ClassEntry)entry).toList();
            this.applyDeletions(path, changedClasses, mappings, delta.getBaseMappings(), saveParameters.getFileNameFormat());
            changedClasses = changedClasses.stream().filter(entry -> !this.isClassEmpty(mappings, (ClassEntry)entry)).collect(Collectors.toList());
            progress.init(changedClasses.size(), I18n.translate("progress.mappings.writing"));
            AtomicInteger steps = new AtomicInteger();
            MappingTranslator translator = new MappingTranslator(mappings, VoidEntryResolver.INSTANCE);
            changedClasses.parallelStream().forEach(classEntry -> {
                block10: {
                    progress.step(steps.getAndIncrement(), classEntry.getFullName());
                    try {
                        ClassEntry fileEntry = classEntry;
                        if (saveParameters.getFileNameFormat() == MappingFileNameFormat.BY_DEOBF) {
                            fileEntry = translator.translate(fileEntry);
                        }
                        Path classPath = this.resolve(path, fileEntry);
                        Files.createDirectories(classPath.getParent(), new FileAttribute[0]);
                        Files.deleteIfExists(classPath);
                        if (useMio) {
                            HashEntryTree<EntryMapping> currentMappings = new HashEntryTree<EntryMapping>();
                            HashSet children = new HashSet();
                            children.add((Entry<?>)classEntry);
                            while (!children.isEmpty()) {
                                Entry child = (Entry)children.stream().findFirst().get();
                                children.remove(child);
                                children.addAll(mappings.getChildren(child));
                                EntryMapping mapping = (EntryMapping)mappings.get(child);
                                currentMappings.insert(child, mapping != null ? mapping : EntryMapping.DEFAULT);
                            }
                            VisitableMappingTree tree = MappingIoConverter.toMappingIo(currentMappings, ProgressListener.none());
                            tree.accept(MappingWriter.create(classPath, MappingFormat.ENIGMA_FILE), VisitOrder.createByName());
                            break block10;
                        }
                        try (LfPrintWriter writer = new LfPrintWriter(Files.newBufferedWriter(classPath, new OpenOption[0]));){
                            this.writeRoot(writer, mappings, (ClassEntry)classEntry);
                        }
                    }
                    catch (Throwable t) {
                        System.err.println("Failed to write class '" + classEntry.getFullName() + "'");
                        t.printStackTrace();
                    }
                }
            });
        }

        private void applyDeletions(Path root, Collection<ClassEntry> changedClasses, EntryTree<EntryMapping> mappings, EntryTree<EntryMapping> oldMappings, MappingFileNameFormat fileNameFormat) {
            MappingTranslator oldMappingTranslator = new MappingTranslator(oldMappings, VoidEntryResolver.INSTANCE);
            Stream<ClassEntry> deletedClassStream = changedClasses.stream().filter(e -> !Objects.equals(oldMappings.get((Entry<?>)e), mappings.get((Entry<?>)e)));
            if (fileNameFormat == MappingFileNameFormat.BY_DEOBF) {
                deletedClassStream = deletedClassStream.map(oldMappingTranslator::translate);
            }
            List<ClassEntry> deletedClasses = deletedClassStream.toList();
            for (ClassEntry classEntry : deletedClasses) {
                try {
                    Files.deleteIfExists(this.resolve(root, classEntry));
                }
                catch (IOException e2) {
                    System.err.println("Failed to delete deleted class '" + String.valueOf(classEntry) + "'");
                    e2.printStackTrace();
                }
            }
            for (ClassEntry classEntry : deletedClasses) {
                String packageName = classEntry.getPackageName();
                if (packageName == null) continue;
                Path packagePath = Paths.get(packageName, new String[0]);
                try {
                    this.deleteDeadPackages(root, packagePath);
                }
                catch (IOException e3) {
                    System.err.println("Failed to delete dead package '" + packageName + "'");
                    e3.printStackTrace();
                }
            }
        }

        private void deleteDeadPackages(Path root, Path packagePath) throws IOException {
            for (int i = packagePath.getNameCount() - 1; i >= 0; --i) {
                Path subPath = packagePath.subpath(0, i + 1);
                Path packagePart = root.resolve(subPath.toString());
                if (!this.isEmpty(packagePart)) continue;
                Files.deleteIfExists(packagePart);
            }
        }

        private boolean isEmpty(Path path) {
            boolean bl;
            block8: {
                DirectoryStream<Path> stream = Files.newDirectoryStream(path);
                try {
                    boolean bl2 = bl = !stream.iterator().hasNext();
                    if (stream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        return false;
                    }
                }
                stream.close();
            }
            return bl;
        }

        private Path resolve(Path root, ClassEntry classEntry) {
            return root.resolve(classEntry.getFullName() + ".mapping");
        }
    };


    protected void writeRoot(PrintWriter writer, EntryTree<EntryMapping> mappings, ClassEntry classEntry) {
        Collection<Entry<?>> children = this.groupChildren(mappings.getChildren(classEntry));
        EntryMapping classEntryMapping = (EntryMapping)mappings.get(classEntry);
        if (classEntryMapping == null) {
            classEntryMapping = EntryMapping.DEFAULT;
        }
        writer.println(this.writeClass(classEntry, classEntryMapping).trim());
        if (classEntryMapping.javadoc() != null) {
            this.writeDocs(writer, classEntryMapping, 0);
        }
        for (Entry<?> child : children) {
            this.writeEntry(writer, mappings, child, 1);
        }
    }

    private void writeDocs(PrintWriter writer, EntryMapping mapping, int depth) {
        String jd = mapping.javadoc();
        if (jd != null) {
            for (String line : jd.split("\\R")) {
                writer.println(this.indent("COMMENT " + MappingHelper.escape(line), depth + 1));
            }
        }
    }

    protected void writeEntry(PrintWriter writer, EntryTree<EntryMapping> mappings, Entry<?> entry, int depth) {
        EntryTreeNode<EntryMapping> node = mappings.findNode(entry);
        if (node == null) {
            return;
        }
        EntryMapping mapping = node.getValue();
        if (mapping == null) {
            mapping = EntryMapping.DEFAULT;
        }
        String line = null;
        if (entry instanceof ClassEntry) {
            ClassEntry classEntry = (ClassEntry)entry;
            line = this.writeClass(classEntry, mapping);
        } else if (entry instanceof MethodEntry) {
            MethodEntry methodEntry = (MethodEntry)entry;
            line = this.writeMethod(methodEntry, mapping);
        } else if (entry instanceof FieldEntry) {
            FieldEntry fieldEntry = (FieldEntry)entry;
            line = this.writeField(fieldEntry, mapping);
        } else if (entry instanceof LocalVariableEntry) {
            LocalVariableEntry varEntry = (LocalVariableEntry)entry;
            if (mapping.targetName() != null) {
                line = this.writeArgument(varEntry, mapping);
            }
        }
        if (line != null) {
            writer.println(this.indent(line, depth));
        }
        if (mapping.javadoc() != null) {
            this.writeDocs(writer, mapping, depth);
        }
        Collection<Entry<?>> children = this.groupChildren(node.getChildren());
        for (Entry<?> child : children) {
            this.writeEntry(writer, mappings, child, depth + 1);
        }
    }

    private Collection<Entry<?>> groupChildren(Collection<Entry<?>> children) {
        ArrayList result = new ArrayList(children.size());
        children.stream().filter(e -> e instanceof FieldEntry).map(e -> (FieldEntry)e).sorted().forEach(result::add);
        children.stream().filter(e -> e instanceof MethodEntry).map(e -> (MethodEntry)e).sorted().forEach(result::add);
        children.stream().filter(e -> e instanceof LocalVariableEntry).map(e -> (LocalVariableEntry)e).sorted().forEach(result::add);
        children.stream().filter(e -> e instanceof ClassEntry).map(e -> (ClassEntry)e).sorted().forEach(result::add);
        return result;
    }

    protected String writeClass(ClassEntry entry, @NotNull EntryMapping mapping) {
        StringBuilder builder = new StringBuilder("CLASS ");
        builder.append(entry.getName()).append(' ');
        this.writeMapping(builder, mapping);
        return builder.toString();
    }

    protected String writeMethod(MethodEntry entry, @NotNull EntryMapping mapping) {
        StringBuilder builder = new StringBuilder("METHOD ");
        builder.append(entry.getName()).append(' ');
        this.writeMapping(builder, mapping);
        builder.append(entry.getDesc().toString());
        return builder.toString();
    }

    protected String writeField(FieldEntry entry, @NotNull EntryMapping mapping) {
        StringBuilder builder = new StringBuilder("FIELD ");
        builder.append(entry.getName()).append(' ');
        this.writeMapping(builder, mapping);
        builder.append(entry.getDesc().toString());
        return builder.toString();
    }

    protected String writeArgument(LocalVariableEntry entry, @NotNull EntryMapping mapping) {
        return "ARG " + entry.getIndex() + " " + mapping.targetName();
    }

    private void writeMapping(StringBuilder builder, EntryMapping mapping) {
        if (mapping.targetName() != null) {
            builder.append(mapping.targetName()).append(' ');
            if (mapping.accessModifier() != AccessModifier.UNCHANGED) {
                builder.append(mapping.accessModifier().getFormattedName()).append(' ');
            }
        } else if (mapping.accessModifier() != AccessModifier.UNCHANGED) {
            builder.append("- ").append(mapping.accessModifier().getFormattedName()).append(' ');
        }
    }

    private String indent(String line, int depth) {
        StringBuilder builder = new StringBuilder();
        builder.append("\t".repeat(Math.max(0, depth)));
        builder.append(line.trim());
        return builder.toString();
    }

    protected boolean isClassEmpty(EntryTree<EntryMapping> mappings, ClassEntry classEntry) {
        Collection<Entry<?>> children = this.groupChildren(mappings.getChildren(classEntry));
        EntryMapping classEntryMapping = (EntryMapping)mappings.get(classEntry);
        return children.isEmpty() && (classEntryMapping == null || this.isMappingEmpty(classEntryMapping));
    }

    private boolean isMappingEmpty(EntryMapping mapping) {
        return mapping.targetName() == null && mapping.accessModifier() == AccessModifier.UNCHANGED && mapping.javadoc() == null;
    }

    @ApiStatus.Internal
    public void write(EntryTree<EntryMapping> mappings, MappingDelta<EntryMapping> mappingDelta, Path path, ProgressListener progressListener, MappingSaveParameters saveParameters, boolean useMio) {
        throw new UnsupportedOperationException("Not implemented");
    }
}

