/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.java.decompiler.code.BytecodeVersion;
import org.jetbrains.java.decompiler.code.Instruction;
import org.jetbrains.java.decompiler.code.InstructionSequence;
import org.jetbrains.java.decompiler.code.SimpleInstructionSequence;
import org.jetbrains.java.decompiler.code.cfg.BasicBlock;
import org.jetbrains.java.decompiler.code.cfg.ControlFlowGraph;
import org.jetbrains.java.decompiler.code.cfg.ExceptionRangeCFG;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.modules.code.DeadCodeHelper;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.StackVarsProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.ValidationHelper;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ExitExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.flow.DirectEdge;
import org.jetbrains.java.decompiler.modules.decompiler.flow.DirectEdgeType;
import org.jetbrains.java.decompiler.modules.decompiler.flow.DirectGraph;
import org.jetbrains.java.decompiler.modules.decompiler.flow.DirectNode;
import org.jetbrains.java.decompiler.modules.decompiler.flow.FlattenStatementsHelper;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.SSAConstructorSparseEx;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.SSAUConstructorSparseEx;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.SimpleSSAReassign;
import org.jetbrains.java.decompiler.modules.decompiler.stats.BasicBlockStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.CatchAllStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionsGraph;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.InterpreterUtil;
import org.jetbrains.java.decompiler.util.collections.ListStack;

public class FinallyProcessor {
    private final Map<BasicBlock, Integer> finallyBlocks = new HashMap<BasicBlock, Integer>();
    private final Set<BasicBlock> catchallBlocks = new HashSet<BasicBlock>();
    private final StructMethod mt;
    private final MethodDescriptor methodDescriptor;
    private final VarProcessor varProcessor;
    private VarVersionsGraph ssuversions;
    private Map<Instruction, Integer> instrRewrites;
    private static final int[] STORE_CODES = new int[]{54, 55, 56, 57, 58};
    private static final int[][] NEXT_CODES = new int[][]{{21, 172}, {22, 173}, {23, 174}, {24, 175}, {25, 176}};

    public FinallyProcessor(StructMethod mt, MethodDescriptor md, VarProcessor varProc) {
        this.mt = mt;
        this.methodDescriptor = md;
        this.varProcessor = varProc;
    }

    public boolean iterateGraph(StructClass cl, StructMethod mt, RootStatement root, ControlFlowGraph graph) {
        this.ssuversions = null;
        BytecodeVersion bytecodeVersion = mt.getBytecodeVersion();
        ListStack stack = new ListStack();
        stack.add(root);
        while (!stack.isEmpty()) {
            Statement stat = (Statement)stack.pop();
            Statement parent = stat.getParent();
            if (parent instanceof CatchAllStatement && stat == parent.getFirst() && !parent.isCopied()) {
                CatchAllStatement fin = (CatchAllStatement)parent;
                BasicBlock head = fin.getBasichead().getBlock();
                BasicBlock handler = fin.getHandler().getBasichead().getBlock();
                if (!this.catchallBlocks.contains(handler)) {
                    if (this.finallyBlocks.containsKey(handler)) {
                        fin.setFinally(true);
                        Integer var = this.finallyBlocks.get(handler);
                        fin.setMonitor(var == null ? null : new VarExprent(var, VarType.VARTYPE_INT, this.varProcessor));
                    } else {
                        Record inf = this.getFinallyInformation(cl, mt, root, fin);
                        if (inf == null) {
                            this.catchallBlocks.add(handler);
                            root.addComment("$VF: Could not inline inconsistent finally blocks", true);
                        } else {
                            if (DecompilerContext.getOption("decompile-finally") && this.verifyFinallyEx(graph, fin, inf)) {
                                this.finallyBlocks.put(handler, null);
                            } else {
                                int varIndex = DecompilerContext.getCounterContainer().getCounterAndIncrement(2);
                                this.varProcessor.getSyntheticSemaphores().add(varIndex);
                                FinallyProcessor.insertSemaphore(graph, FinallyProcessor.getAllBasicBlocks(fin.getFirst()), head, handler, varIndex, inf, bytecodeVersion);
                                this.finallyBlocks.put(handler, varIndex);
                                if (DecompilerContext.getOption("decompiler-comments")) {
                                    root.addComment("$VF: Could not verify finally blocks. A semaphore variable has been added to preserve control flow.", true);
                                }
                            }
                            DeadCodeHelper.removeDeadBlocks(graph);
                            DeadCodeHelper.removeEmptyBlocks(graph);
                            DeadCodeHelper.mergeBasicBlocks(graph);
                        }
                        return true;
                    }
                }
            }
            stack.addAll(stat.getStats());
        }
        return false;
    }

    private Record getFinallyInformation(StructClass cl, StructMethod mt, RootStatement root, CatchAllStatement fstat) {
        ExprProcessor proc = new ExprProcessor(this.methodDescriptor, this.varProcessor);
        proc.processStatement(root, cl);
        if (this.ssuversions == null) {
            SSAConstructorSparseEx ssa = new SSAConstructorSparseEx();
            ssa.splitVariables(root, mt);
            this.instrRewrites = SimpleSSAReassign.reassignSSAForm(ssa, root);
            StackVarsProcessor.setVersionsToNull(root);
            SSAUConstructorSparseEx ssau = new SSAUConstructorSparseEx();
            ssau.splitVariables(root, mt);
            this.ssuversions = ssau.getSsuVersions();
            StackVarsProcessor.setVersionsToNull(root);
        }
        LinkedHashMap<BasicBlock, Boolean> mapLast = new LinkedHashMap<BasicBlock, Boolean>();
        BasicBlockStatement firstBlockStatement = fstat.getHandler().getBasichead();
        BasicBlock firstBasicBlock = firstBlockStatement.getBlock();
        Instruction instrFirst = firstBasicBlock.getInstruction(0);
        int firstcode = 0;
        switch (instrFirst.opcode) {
            case 87: {
                firstcode = 1;
                break;
            }
            case 58: {
                firstcode = 2;
            }
        }
        SSAConstructorSparseEx ssa = new SSAConstructorSparseEx();
        ssa.splitVariables(root, mt);
        List<Exprent> lstExprents = firstBlockStatement.getExprents();
        VarVersionPair varpaar = new VarVersionPair((VarExprent)((AssignmentExprent)lstExprents.get(firstcode == 2 ? 1 : 0)).getLeft());
        FlattenStatementsHelper flatthelper = new FlattenStatementsHelper();
        DirectGraph dgraph = flatthelper.buildDirectGraph(root);
        LinkedList<DirectNode> stack = new LinkedList<DirectNode>();
        stack.add(dgraph.first);
        HashSet<DirectNode> setVisited = new HashSet<DirectNode>();
        while (!stack.isEmpty()) {
            DirectNode node = (DirectNode)stack.removeFirst();
            if (setVisited.contains(node)) continue;
            setVisited.add(node);
            BasicBlockStatement blockStatement = null;
            if (node.block != null) {
                blockStatement = node.block;
            } else if (node.getPredecessors(DirectEdgeType.REGULAR).size() == 1) {
                blockStatement = node.getPredecessors((DirectEdgeType)DirectEdgeType.REGULAR).get((int)0).getSource().block;
            }
            boolean isTrueExit = true;
            if (firstcode != 1) {
                isTrueExit = false;
                for (int i = 0; i < node.exprents.size(); ++i) {
                    ExitExprent exexpr;
                    AssignmentExprent assexpr;
                    Exprent exprent = node.exprents.get(i);
                    if (firstcode == 0) {
                        ExitExprent exexpr2;
                        List<Exprent> lst = exprent.getAllExprents();
                        lst.add(exprent);
                        boolean found = false;
                        for (Exprent expr : lst) {
                            if (!(expr instanceof VarExprent) || !new VarVersionPair((VarExprent)expr).equals(varpaar)) continue;
                            found = true;
                            break;
                        }
                        if (!found) continue;
                        found = false;
                        if (exprent instanceof ExitExprent && (exexpr2 = (ExitExprent)exprent).getExitType() == ExitExprent.Type.THROW && exexpr2.getValue() instanceof VarExprent) {
                            found = true;
                        }
                        if (!found) {
                            return null;
                        }
                        isTrueExit = true;
                        continue;
                    }
                    if (firstcode != 2 || !(exprent instanceof AssignmentExprent) || !((assexpr = (AssignmentExprent)exprent).getRight() instanceof VarExprent) || !new VarVersionPair((VarExprent)assexpr.getRight()).equals(varpaar)) continue;
                    Exprent next = null;
                    if (i == node.exprents.size() - 1) {
                        if (node.getSuccessors(DirectEdgeType.REGULAR).size() == 1) {
                            DirectNode nd = node.getSuccessors(DirectEdgeType.REGULAR).get(0).getDestination();
                            if (!nd.exprents.isEmpty()) {
                                next = nd.exprents.get(0);
                            }
                        }
                    } else {
                        next = node.exprents.get(i + 1);
                    }
                    boolean found = false;
                    if (next != null && next instanceof ExitExprent && (exexpr = (ExitExprent)next).getExitType() == ExitExprent.Type.THROW && exexpr.getValue() instanceof VarExprent && assexpr.getLeft().equals(exexpr.getValue())) {
                        found = true;
                    }
                    if (!found) {
                        return null;
                    }
                    isTrueExit = true;
                }
            }
            if (blockStatement != null && blockStatement.getBlock() != null) {
                Statement handler = fstat.getHandler();
                for (StatEdge edge : blockStatement.getSuccessorEdges(0x40000000)) {
                    Boolean existingFlag;
                    if (edge.getType() == 1 || !handler.containsStatement(blockStatement) || handler.containsStatement(edge.getDestination()) || (existingFlag = (Boolean)mapLast.get(blockStatement.getBlock())) != null && existingFlag.booleanValue()) continue;
                    mapLast.put(blockStatement.getBlock(), isTrueExit);
                    break;
                }
            }
            for (DirectEdge suc : node.getSuccessors(DirectEdgeType.REGULAR)) {
                stack.add(suc.getDestination());
            }
        }
        if (fstat.getHandler() instanceof BasicBlockStatement) {
            boolean isEmpty = false;
            boolean isFirstLast = mapLast.containsKey(firstBasicBlock);
            InstructionSequence seq = firstBasicBlock.getSeq();
            switch (firstcode) {
                case 0: {
                    isEmpty = isFirstLast && seq.length() == 1;
                    break;
                }
                case 1: {
                    isEmpty = seq.length() == 1;
                    break;
                }
                case 2: {
                    boolean bl;
                    if (isFirstLast) {
                        if (seq.length() == 3) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    bl = isEmpty = seq.length() == 1;
                }
            }
            if (isEmpty) {
                firstcode = 3;
            }
        }
        return new Record(firstcode, mapLast);
    }

    private static void insertSemaphore(ControlFlowGraph graph, Set<BasicBlock> setTry, BasicBlock head, BasicBlock handler, int var, Record information, BytecodeVersion bytecode_version) {
        HashSet<BasicBlock> setCopy = new HashSet<BasicBlock>(setTry);
        int finallytype = information.firstCode;
        Map<BasicBlock, Boolean> mapLast = information.mapLast;
        FinallyProcessor.removeExceptionInstructionsEx(handler, 1, finallytype);
        for (Map.Entry<BasicBlock, Boolean> entry : mapLast.entrySet()) {
            BasicBlock last = entry.getKey();
            if (!entry.getValue().booleanValue()) continue;
            FinallyProcessor.removeExceptionInstructionsEx(last, 2, finallytype);
            graph.getFinallyExits().add(last);
        }
        int store_length = var <= 3 ? 1 : (var <= 128 ? 2 : 4);
        for (BasicBlock block : setTry) {
            List<BasicBlock> lstSucc = block.getSuccs();
            for (BasicBlock dest : lstSucc) {
                if (dest == graph.getLast() || setCopy.contains(dest)) continue;
                SimpleInstructionSequence seq = new SimpleInstructionSequence();
                seq.addInstruction(Instruction.create(16, false, 1, bytecode_version, new int[]{0}, 1), -1);
                seq.addInstruction(Instruction.create(54, false, 1, bytecode_version, new int[]{var}, store_length), -1);
                BasicBlock newblock = new BasicBlock(++graph.last_id);
                newblock.setSeq(seq);
                block.replaceSuccessor(dest, newblock);
                newblock.addSuccessor(dest);
                setCopy.add(newblock);
                graph.getBlocks().addWithKey(newblock, newblock.id);
                for (int j = 0; j < block.getSuccExceptions().size(); ++j) {
                    BasicBlock hd = block.getSuccExceptions().get(j);
                    newblock.addSuccessorException(hd);
                    ExceptionRangeCFG range = graph.getExceptionRange(hd, block);
                    range.getProtectedRange().add(newblock);
                }
            }
        }
        SimpleInstructionSequence simpleInstructionSequence = new SimpleInstructionSequence();
        simpleInstructionSequence.addInstruction(Instruction.create(16, false, 1, bytecode_version, new int[]{1}, 1), -1);
        simpleInstructionSequence.addInstruction(Instruction.create(54, false, 1, bytecode_version, new int[]{var}, store_length), -1);
        BasicBlock newhead = new BasicBlock(++graph.last_id);
        newhead.setSeq(simpleInstructionSequence);
        FinallyProcessor.insertBlockBefore(graph, head, newhead);
        SimpleInstructionSequence simpleInstructionSequence2 = new SimpleInstructionSequence();
        simpleInstructionSequence2.addInstruction(Instruction.create(16, false, 1, bytecode_version, new int[]{0}, 1), -1);
        simpleInstructionSequence2.addInstruction(Instruction.create(54, false, 1, bytecode_version, new int[]{var}, store_length), -1);
        BasicBlock newheadinit = new BasicBlock(++graph.last_id);
        newheadinit.setSeq(simpleInstructionSequence2);
        FinallyProcessor.insertBlockBefore(graph, newhead, newheadinit);
        setCopy.add(newhead);
        setCopy.add(newheadinit);
        for (BasicBlock hd : new HashSet<BasicBlock>(newheadinit.getSuccExceptions())) {
            ExceptionRangeCFG range = graph.getExceptionRange(hd, newheadinit);
            if (!setCopy.containsAll(range.getProtectedRange())) continue;
            newheadinit.removeSuccessorException(hd);
            range.getProtectedRange().remove(newheadinit);
        }
    }

    private static void insertBlockBefore(ControlFlowGraph graph, BasicBlock oldblock, BasicBlock newblock) {
        ArrayList<BasicBlock> lstTemp = new ArrayList<BasicBlock>();
        lstTemp.addAll(oldblock.getPreds());
        lstTemp.addAll(oldblock.getPredExceptions());
        for (BasicBlock pred : lstTemp) {
            pred.replaceSuccessor(oldblock, newblock);
        }
        for (BasicBlock hd : oldblock.getSuccExceptions()) {
            newblock.addSuccessorException(hd);
            ExceptionRangeCFG range = graph.getExceptionRange(hd, oldblock);
            range.getProtectedRange().add(newblock);
        }
        for (ExceptionRangeCFG range : graph.getExceptions()) {
            if (range.getHandler() != oldblock) continue;
            range.setHandler(newblock);
        }
        newblock.addSuccessor(oldblock);
        graph.getBlocks().addWithKey(newblock, newblock.id);
        if (graph.getFirst() == oldblock) {
            graph.setFirst(newblock);
        }
    }

    private static Set<BasicBlock> getAllBasicBlocks(Statement stat) {
        LinkedList<Statement> lst = new LinkedList<Statement>();
        lst.add(stat);
        int index = 0;
        do {
            Statement st;
            if ((st = (Statement)lst.get(index)) instanceof BasicBlockStatement) {
                ++index;
                continue;
            }
            lst.addAll(st.getStats());
            lst.remove(index);
        } while (index < lst.size());
        LinkedHashSet<BasicBlock> res = new LinkedHashSet<BasicBlock>();
        for (Statement st : lst) {
            res.add(((BasicBlockStatement)st).getBlock());
        }
        return res;
    }

    private boolean verifyFinallyEx(ControlFlowGraph graph, CatchAllStatement fstat, Record information) {
        BasicBlock firstsuc;
        Set<BasicBlock> tryBlocks = FinallyProcessor.getAllBasicBlocks(fstat.getFirst());
        Set<BasicBlock> catchBlocks = FinallyProcessor.getAllBasicBlocks(fstat.getHandler());
        int finallytype = information.firstCode;
        Map<BasicBlock, Boolean> mapLast = information.mapLast;
        BasicBlock first = fstat.getHandler().getBasichead().getBlock();
        boolean skippedFirst = false;
        if (finallytype == 3) {
            FinallyProcessor.removeExceptionInstructionsEx(first, 3, finallytype);
            if (mapLast.containsKey(first)) {
                graph.getFinallyExits().add(first);
            }
            return true;
        }
        if (first.getSeq().length() == 1 && finallytype > 0 && catchBlocks.contains(firstsuc = first.getSuccs().get(0))) {
            first = firstsuc;
            skippedFirst = true;
        }
        LinkedHashSet<BasicBlock> startBlocks = new LinkedHashSet<BasicBlock>();
        for (BasicBlock block : tryBlocks) {
            startBlocks.addAll(block.getSuccs());
        }
        startBlocks.remove(graph.getLast());
        startBlocks.removeAll(tryBlocks);
        ArrayList<Area> lstAreas = new ArrayList<Area>();
        Set<BasicBlock> sideExits = null;
        for (BasicBlock start : startBlocks) {
            Area arr = this.compareSubgraphsEx(graph, start, catchBlocks, first, finallytype, mapLast, skippedFirst);
            if (arr == null) {
                return false;
            }
            lstAreas.add(arr);
            if (sideExits == null) {
                sideExits = arr.sideExits;
                continue;
            }
            ValidationHelper.validateTrue(sideExits.equals(arr.sideExits), "Side exits are not equal");
        }
        for (Area area : lstAreas) {
            FinallyProcessor.deleteArea(graph, area);
        }
        BasicBlock trueExit = null;
        for (Map.Entry<BasicBlock, Boolean> entry : mapLast.entrySet()) {
            BasicBlock last = entry.getKey();
            if (!entry.getValue().booleanValue()) continue;
            FinallyProcessor.removeExceptionInstructionsEx(last, 2, finallytype);
            graph.getFinallyExits().add(last);
            ValidationHelper.validateTrue(trueExit == null, "More than one true exit");
            trueExit = last;
        }
        FinallyProcessor.removeExceptionInstructionsEx(fstat.getHandler().getBasichead().getBlock(), 1, finallytype);
        return true;
    }

    private Area compareSubgraphsEx(ControlFlowGraph graph, BasicBlock startSample, Set<BasicBlock> catchBlocks, BasicBlock startCatch, int finallytype, Map<BasicBlock, Boolean> mapLast, boolean skippedFirst) {
        LinkedList<BlockStackEntry> stack = new LinkedList<BlockStackEntry>();
        HashSet<BasicBlock> setSample = new HashSet<BasicBlock>();
        HashMap<CallSite, BasicBlock[]> mapNext = new HashMap<CallSite, BasicBlock[]>();
        class BlockStackEntry {
            public final BasicBlock blockCatch;
            public final BasicBlock blockSample;
            public final List<int[]> lstStoreVars;

            BlockStackEntry(BasicBlock blockCatch, BasicBlock blockSample, List<int[]> lstStoreVars) {
                this.blockCatch = blockCatch;
                this.blockSample = blockSample;
                this.lstStoreVars = new ArrayList<int[]>(lstStoreVars);
            }
        }
        stack.add(new BlockStackEntry(startCatch, startSample, new ArrayList<int[]>()));
        while (!stack.isEmpty()) {
            BasicBlock sucSample;
            BasicBlock sucCatch;
            int i;
            boolean isLastBlock;
            boolean isTrueLastBlock;
            BlockStackEntry entry = (BlockStackEntry)stack.remove(0);
            BasicBlock blockCatch = entry.blockCatch;
            BasicBlock blockSample = entry.blockSample;
            boolean isFirstBlock = !skippedFirst && blockCatch == startCatch;
            if (!this.compareBasicBlocksEx(graph, blockCatch, blockSample, (isFirstBlock ? 1 : 0) | ((isTrueLastBlock = (isLastBlock = mapLast.containsKey(blockCatch)) && mapLast.get(blockCatch) != false) ? 2 : 0), finallytype, entry.lstStoreVars)) {
                return null;
            }
            if (blockSample.getSuccs().size() != blockCatch.getSuccs().size()) {
                return null;
            }
            setSample.add(blockSample);
            for (i = 0; i < blockCatch.getSuccs().size(); ++i) {
                sucCatch = blockCatch.getSuccs().get(i);
                sucSample = blockSample.getSuccs().get(i);
                if (!catchBlocks.contains(sucCatch) || setSample.contains(sucSample)) continue;
                stack.add(new BlockStackEntry(sucCatch, sucSample, entry.lstStoreVars));
            }
            if (!isLastBlock || !blockSample.getSeq().isEmpty()) {
                if (blockCatch.getSuccExceptions().size() == blockSample.getSuccExceptions().size()) {
                    for (i = 0; i < blockCatch.getSuccExceptions().size(); ++i) {
                        String excSample;
                        sucCatch = blockCatch.getSuccExceptions().get(i);
                        sucSample = blockSample.getSuccExceptions().get(i);
                        String excCatch = graph.getExceptionRange(sucCatch, blockCatch).getUniqueExceptionsString();
                        boolean equalexc = Objects.equals(excCatch, excSample = graph.getExceptionRange(sucSample, blockSample).getUniqueExceptionsString());
                        if (equalexc) {
                            if (!catchBlocks.contains(sucCatch) || setSample.contains(sucSample)) continue;
                            List<int[]> lst = entry.lstStoreVars;
                            if (sucCatch.getSeq().length() > 0 && sucSample.getSeq().length() > 0) {
                                Instruction instrCatch = sucCatch.getSeq().getInstr(0);
                                Instruction instrSample = sucSample.getSeq().getInstr(0);
                                if (instrCatch.opcode == 58 && instrSample.opcode == 58) {
                                    lst = new ArrayList<int[]>(lst);
                                    lst.add(new int[]{instrCatch.operand(0), instrSample.operand(0)});
                                }
                            }
                            stack.add(new BlockStackEntry(sucCatch, sucSample, lst));
                            continue;
                        }
                        return null;
                    }
                } else {
                    return null;
                }
            }
            if (!isLastBlock) continue;
            HashSet<BasicBlock> setSuccs = new HashSet<BasicBlock>(blockSample.getSuccs());
            setSuccs.removeAll(setSample);
            for (BlockStackEntry stackent : stack) {
                setSuccs.remove(stackent.blockSample);
            }
            for (BasicBlock succ : setSuccs) {
                if (graph.getLast() == succ) continue;
                mapNext.put((CallSite)((Object)(blockSample.getId() + "#" + succ.getId())), new BasicBlock[]{blockSample, succ, isTrueLastBlock ? succ : null});
            }
        }
        return new Area(startSample, setSample, FinallyProcessor.getUniqueNext(graph, new HashSet<BasicBlock[]>(mapNext.values())), FinallyProcessor.getSideExits(mapNext.values()));
    }

    private static Set<BasicBlock> getSideExits(Collection<BasicBlock[]> setNext) {
        HashSet<BasicBlock> set = new HashSet<BasicBlock>();
        for (BasicBlock[] next : setNext) {
            if (next[2] != null) continue;
            set.add(next[1]);
        }
        return set;
    }

    private static BasicBlock getUniqueNext(ControlFlowGraph graph, Set<BasicBlock[]> setNext) {
        BasicBlock next = null;
        boolean multiple = false;
        for (BasicBlock[] arr : setNext) {
            if (arr[2] != null) {
                next = arr[1];
                multiple = false;
                break;
            }
            if (next == null) {
                next = arr[1];
            } else if (next != arr[1]) {
                multiple = true;
            }
            if (arr[1].getPreds().size() != 1) continue;
            next = arr[1];
        }
        if (multiple) {
            for (BasicBlock[] arr : setNext) {
                BasicBlock block = arr[1];
                if (block == next) continue;
                if (InterpreterUtil.equalSets(next.getSuccs(), block.getSuccs())) {
                    InstructionSequence seqNext = next.getSeq();
                    InstructionSequence seqBlock = block.getSeq();
                    if (seqNext.length() == seqBlock.length()) {
                        for (int i = 0; i < seqNext.length(); ++i) {
                            Instruction instrBlock;
                            Instruction instrNext = seqNext.getInstr(i);
                            if (!Instruction.equals(instrNext, instrBlock = seqBlock.getInstr(i))) {
                                return null;
                            }
                            for (int j = 0; j < instrNext.operandsCount(); ++j) {
                                if (instrNext.operand(j) == instrBlock.operand(j)) continue;
                                return null;
                            }
                        }
                        continue;
                    }
                    return null;
                }
                return null;
            }
            for (BasicBlock[] arr : setNext) {
                if (arr[1] == next) continue;
                arr[0].removeSuccessor(arr[1]);
                arr[0].addSuccessor(next);
            }
            DeadCodeHelper.removeDeadBlocks(graph);
        }
        return next;
    }

    private boolean compareBasicBlocksEx(ControlFlowGraph graph, BasicBlock pattern, BasicBlock sample, int type, int finallytype, List<int[]> lstStoreVars) {
        InstructionSequence seqPattern = pattern.getSeq();
        InstructionSequence seqSample = sample.getSeq();
        List<Integer> instrOldOffsetsSample = sample.getInstrOldOffsets();
        if (type != 0) {
            seqPattern = seqPattern.clone();
            if ((type & 1) > 0 && finallytype > 0) {
                seqPattern.removeInstruction(0);
            }
            if ((type & 2) > 0) {
                if (finallytype == 0 || finallytype == 2) {
                    seqPattern.removeLast();
                }
                if (finallytype == 2) {
                    seqPattern.removeLast();
                }
            }
        }
        if (seqPattern.length() > seqSample.length()) {
            return false;
        }
        for (int i = 0; i < seqPattern.length(); ++i) {
            Instruction instrSample;
            Instruction instrPattern = seqPattern.getInstr(i);
            if (this.equalInstructions(instrPattern, instrSample = seqSample.getInstr(i), lstStoreVars)) continue;
            return false;
        }
        if (seqPattern.length() < seqSample.length()) {
            SimpleInstructionSequence seq = new SimpleInstructionSequence();
            LinkedList<Integer> oldOffsets = new LinkedList<Integer>();
            for (int i = seqSample.length() - 1; i >= seqPattern.length(); --i) {
                seq.addInstruction(0, seqSample.getInstr(i), -1);
                oldOffsets.addFirst(sample.getOldOffset(i));
                seqSample.removeInstruction(i);
                if (i >= instrOldOffsetsSample.size()) continue;
                instrOldOffsetsSample.remove(i);
            }
            BasicBlock newblock = new BasicBlock(++graph.last_id);
            newblock.setSeq(seq);
            newblock.getInstrOldOffsets().addAll(oldOffsets);
            ArrayList<BasicBlock> lstTemp = new ArrayList<BasicBlock>(sample.getSuccs());
            for (BasicBlock suc : lstTemp) {
                sample.removeSuccessor(suc);
                newblock.addSuccessor(suc);
            }
            sample.addSuccessor(newblock);
            graph.getBlocks().addWithKey(newblock, newblock.id);
            Set<BasicBlock> setFinallyExits = graph.getFinallyExits();
            if (setFinallyExits.contains(sample)) {
                setFinallyExits.remove(sample);
                setFinallyExits.add(newblock);
            }
            for (int j = 0; j < sample.getSuccExceptions().size(); ++j) {
                BasicBlock hd = sample.getSuccExceptions().get(j);
                newblock.addSuccessorException(hd);
                ExceptionRangeCFG range = graph.getExceptionRange(hd, sample);
                range.getProtectedRange().add(newblock);
            }
        }
        return true;
    }

    public boolean equalInstructions(Instruction first, Instruction second, List<int[]> lstStoreVars) {
        if (!Instruction.equals(first, second)) {
            return false;
        }
        if (first.group != 2 && first.group != 3) {
            for (int i = 0; i < first.operandsCount(); ++i) {
                int secondOp;
                int firstOp = first.operand(i);
                if (firstOp == (secondOp = second.operand(i))) continue;
                if (first.opcode == 25) {
                    for (int[] arr : lstStoreVars) {
                        if (arr[0] != firstOp || arr[1] != secondOp) continue;
                        return true;
                    }
                } else if (first.opcode == 58) {
                    lstStoreVars.add(new int[]{firstOp, secondOp});
                    return true;
                }
                boolean ok = false;
                if (FinallyProcessor.isOpcVar(first.opcode)) {
                    if (this.instrRewrites.containsKey(first)) {
                        firstOp = this.instrRewrites.get(first);
                    }
                    if (this.instrRewrites.containsKey(second)) {
                        secondOp = this.instrRewrites.get(second);
                    }
                    if (this.ssuversions.areVarsAnalogous(firstOp, secondOp)) {
                        ok = true;
                    }
                }
                if (ok) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isOpcVar(int opc) {
        return opc >= 21 && opc <= 86;
    }

    private static void deleteArea(ControlFlowGraph graph, Area area) {
        BasicBlock start = area.start;
        BasicBlock next = area.next;
        if (start == next) {
            return;
        }
        if (next == null) {
            next = graph.getLast();
        }
        HashSet<BasicBlock> setCommonExceptionHandlers = new HashSet<BasicBlock>(next.getSuccExceptions());
        for (BasicBlock pred : start.getPreds()) {
            setCommonExceptionHandlers.retainAll(pred.getSuccExceptions());
        }
        boolean is_outside_range = false;
        HashSet<BasicBlock> setPredecessors = new HashSet<BasicBlock>(start.getPreds());
        for (BasicBlock pred : setPredecessors) {
            pred.replaceSuccessor(start, next);
        }
        Set<BasicBlock> setBlocks = area.sample;
        HashSet<ExceptionRangeCFG> setCommonRemovedExceptionRanges = null;
        for (BasicBlock block : setBlocks) {
            if (!graph.getBlocks().containsKey(block.id)) continue;
            if (!block.getSuccExceptions().containsAll(setCommonExceptionHandlers)) {
                is_outside_range = true;
            }
            HashSet<ExceptionRangeCFG> setRemovedExceptionRanges = new HashSet<ExceptionRangeCFG>();
            for (BasicBlock handler : block.getSuccExceptions()) {
                setRemovedExceptionRanges.add(graph.getExceptionRange(handler, block));
            }
            if (setCommonRemovedExceptionRanges == null) {
                setCommonRemovedExceptionRanges = setRemovedExceptionRanges;
            } else {
                setCommonRemovedExceptionRanges.retainAll(setRemovedExceptionRanges);
            }
            if (block.getSeq().isEmpty() && block.getSuccs().size() == 1) {
                BasicBlock succs = block.getSuccs().get(0);
                for (BasicBlock pred : new ArrayList<BasicBlock>(block.getPreds())) {
                    if (setBlocks.contains(pred)) continue;
                    pred.replaceSuccessor(block, succs);
                }
                if (graph.getFirst() == block) {
                    graph.setFirst(succs);
                }
            }
            graph.removeBlock(block);
        }
        if (is_outside_range) {
            BasicBlock emptyblock = new BasicBlock(++graph.last_id);
            graph.getBlocks().addWithKey(emptyblock, emptyblock.id);
            for (ExceptionRangeCFG range : setCommonRemovedExceptionRanges) {
                emptyblock.addSuccessorException(range.getHandler());
                range.getProtectedRange().add(emptyblock);
            }
            emptyblock.addSuccessor(next);
            for (BasicBlock pred : setPredecessors) {
                pred.replaceSuccessor(next, emptyblock);
            }
        }
    }

    private static void removeExceptionInstructionsEx(BasicBlock block, int blocktype, int finallytype) {
        InstructionSequence seq = block.getSeq();
        List<Integer> instrOldOffsets = block.getInstrOldOffsets();
        if (finallytype == 3) {
            for (int i = seq.length() - 1; i >= 0; --i) {
                seq.removeInstruction(i);
                instrOldOffsets.remove(i);
            }
        } else {
            if ((blocktype & 1) > 0 && (finallytype == 2 || finallytype == 1)) {
                seq.removeInstruction(0);
                instrOldOffsets.remove(0);
            }
            if ((blocktype & 2) > 0) {
                if (finallytype == 2 || finallytype == 0) {
                    seq.removeLast();
                    instrOldOffsets.remove(instrOldOffsets.size() - 1);
                }
                if (finallytype == 2) {
                    seq.removeLast();
                    instrOldOffsets.remove(instrOldOffsets.size() - 1);
                }
            }
        }
    }

    private static void inlineReturnVar(ControlFlowGraph graph, BasicBlock handler) {
        ArrayList<ExceptionRangeCFG> ranges = new ArrayList<ExceptionRangeCFG>();
        for (ExceptionRangeCFG ex : graph.getExceptions()) {
            if (ex.getHandler() != handler) continue;
            ranges.add(ex);
        }
        HashSet<BasicBlock> exits = new HashSet<BasicBlock>();
        for (ExceptionRangeCFG ex : ranges) {
            for (BasicBlock block : ex.getProtectedRange()) {
                List<BasicBlock> blockEx = block.getSuccExceptions();
                for (BasicBlock suc : block.getSuccs()) {
                    if (suc.getSuccExceptions().equals(blockEx)) continue;
                    exits.add(block);
                }
            }
        }
        block4: for (BasicBlock exit : exits) {
            Instruction instr;
            int index;
            if (exit.getSuccs().size() != 1 || (index = FinallyProcessor.indexOf(instr = exit.getLastInstruction())) < 0) continue;
            LinkedList<BasicBlock> stack = new LinkedList<BasicBlock>(exit.getPreds());
            HashSet<BasicBlock> visited = new HashSet<BasicBlock>();
            while (!stack.isEmpty()) {
                BasicBlock pred = (BasicBlock)stack.pop();
                if (pred == handler) continue block4;
                for (Instruction predInstr : pred.getSeq()) {
                    if (predInstr.opcode != STORE_CODES[index] || predInstr.operand(0) != instr.operand(0)) continue;
                    continue block4;
                }
                for (BasicBlock p : pred.getPreds()) {
                    if (!visited.add(p)) continue;
                    stack.push(p);
                }
            }
            InstructionSequence nextSeq = exit.getSuccs().get(0).getSeq();
            if (nextSeq.length() != 2 || nextSeq.getInstr((int)0).opcode != NEXT_CODES[index][0] || nextSeq.getInstr((int)1).opcode != NEXT_CODES[index][1] || instr.operand(0) != nextSeq.getInstr(0).operand(0)) continue;
            exit.getSeq().removeLast();
            exit.getSeq().addInstruction(nextSeq.getInstr(1), -1);
            nextSeq.clear();
        }
    }

    private static int indexOf(Instruction instr) {
        for (int i = 0; i < STORE_CODES.length; ++i) {
            int code = STORE_CODES[i];
            if (instr.opcode != code) continue;
            return i;
        }
        return -1;
    }

    private static final class Area {
        private final BasicBlock start;
        private final Set<BasicBlock> sample;
        private final BasicBlock next;
        private final Set<BasicBlock> sideExits;

        private Area(BasicBlock start, Set<BasicBlock> sample, BasicBlock next, Set<BasicBlock> sideExits) {
            this.start = start;
            this.sample = sample;
            this.next = next;
            this.sideExits = sideExits;
        }
    }

    private static final class Record {
        private final int firstCode;
        private final Map<BasicBlock, Boolean> mapLast;

        private Record(int firstCode, Map<BasicBlock, Boolean> mapLast) {
            this.firstCode = firstCode;
            this.mapLast = mapLast;
        }
    }
}

