/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.java.decompiler.modules.decompiler.SequenceHelper;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.TryWithResourcesProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.CatchAllStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.CatchStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SequenceStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.struct.StructClass;

public class TryHelper {
    public static boolean enhanceTryStats(RootStatement root, StructClass cl) {
        boolean ret = TryHelper.makeTryWithResourceRec(cl, root);
        if (ret) {
            SequenceHelper.condenseSequences(root);
            if (!cl.getVersion().hasNewTryWithResources() && TryHelper.collapseTryRec(root)) {
                SequenceHelper.condenseSequences(root);
            }
        }
        if (cl.getVersion().hasNewTryWithResources() && TryHelper.mergeTrys(root)) {
            SequenceHelper.condenseSequences(root);
            ret = true;
        }
        return ret;
    }

    private static boolean makeTryWithResourceRec(StructClass cl, Statement stat) {
        if (cl.getVersion().hasNewTryWithResources()) {
            boolean ret = false;
            if (stat instanceof CatchStatement && TryWithResourcesProcessor.makeTryWithResourceJ11((CatchStatement)stat)) {
                ret = true;
            }
            for (Statement st : new ArrayList(stat.getStats())) {
                if (!TryHelper.makeTryWithResourceRec(cl, st)) continue;
                ret = true;
            }
            return ret;
        }
        if (stat instanceof CatchAllStatement && ((CatchAllStatement)stat).isFinally() && TryWithResourcesProcessor.makeTryWithResource((CatchAllStatement)stat)) {
            return true;
        }
        for (Statement st : new ArrayList(stat.getStats())) {
            if (!TryHelper.makeTryWithResourceRec(cl, st)) continue;
            return true;
        }
        return false;
    }

    private static boolean mergeTrys(Statement root) {
        boolean ret = false;
        if (root instanceof CatchStatement && TryHelper.mergeTry((CatchStatement)root)) {
            ret = true;
        }
        for (Statement stat : new ArrayList(root.getStats())) {
            ret |= TryHelper.mergeTrys(stat);
        }
        return ret;
    }

    private static boolean mergeTry(CatchStatement stat) {
        List<Exprent> resources;
        if (stat.getStats().isEmpty()) {
            return false;
        }
        Statement inner = (Statement)stat.getStats().get(0);
        if (inner instanceof CatchStatement && !(resources = ((CatchStatement)inner).getResources()).isEmpty() && inner.getStats().size() == 1) {
            stat.getResources().addAll(resources);
            stat.getVarDefinitions().addAll(inner.getVarDefinitions());
            Statement innerBlock = (Statement)inner.getStats().get(0);
            List<StatEdge> innerEdges = inner.getAllSuccessorEdges();
            for (StatEdge succ : innerBlock.getAllSuccessorEdges()) {
                boolean found = false;
                for (StatEdge innerEdge : innerEdges) {
                    if (succ.getDestination() != innerEdge.getDestination() || succ.getType() != innerEdge.getType()) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
                innerBlock.removeSuccessor(succ);
            }
            stat.replaceStatement(inner, innerBlock);
            return true;
        }
        return false;
    }

    private static boolean collapseTryRec(Statement stat) {
        if (stat instanceof CatchStatement && TryHelper.collapseTry((CatchStatement)stat)) {
            return true;
        }
        for (Statement st : stat.getStats()) {
            if (!TryHelper.collapseTryRec(st)) continue;
            return true;
        }
        return false;
    }

    private static boolean collapseTry(CatchStatement catchStat) {
        CatchStatement toRemove;
        List<Exprent> resources;
        Statement parent = catchStat;
        if (parent.getFirst() != null && parent.getFirst() instanceof SequenceStatement) {
            parent = parent.getFirst();
        }
        if (parent != null && parent.getFirst() != null && parent.getFirst() instanceof CatchStatement && !(resources = (toRemove = (CatchStatement)parent.getFirst()).getResources()).isEmpty()) {
            catchStat.getResources().addAll(resources);
            catchStat.getVarDefinitions().addAll(toRemove.getVarDefinitions());
            parent.replaceStatement(toRemove, toRemove.getFirst());
            if (!toRemove.getVars().isEmpty()) {
                for (int i = 0; i < toRemove.getVars().size(); ++i) {
                    catchStat.getVars().add(i, toRemove.getVars().get(i));
                    catchStat.getExctStrings().add(i, toRemove.getExctStrings().get(i));
                    catchStat.getStats().add(i + 1, (Statement)catchStat.getStats().get(i + 1));
                }
            }
            return true;
        }
        return false;
    }
}

