/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.analysis.ReferenceTreeNode;
import cuchaz.enigma.analysis.index.JarIndex;
import cuchaz.enigma.analysis.index.ReferenceIndex;
import cuchaz.enigma.translation.Translator;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.MethodDefEntry;
import java.util.HashSet;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class ClassReferenceTreeNode
extends DefaultMutableTreeNode
implements ReferenceTreeNode<ClassEntry, MethodDefEntry> {
    private Translator deobfuscatingTranslator;
    private ClassEntry entry;
    private EntryReference<ClassEntry, MethodDefEntry> reference;

    public ClassReferenceTreeNode(Translator deobfuscatingTranslator, ClassEntry entry) {
        this.deobfuscatingTranslator = deobfuscatingTranslator;
        this.entry = entry;
        this.reference = null;
    }

    public ClassReferenceTreeNode(Translator deobfuscatingTranslator, EntryReference<ClassEntry, MethodDefEntry> reference) {
        this.deobfuscatingTranslator = deobfuscatingTranslator;
        this.entry = (ClassEntry)reference.entry;
        this.reference = reference;
    }

    @Override
    public ClassEntry getEntry() {
        return this.entry;
    }

    @Override
    public EntryReference<ClassEntry, MethodDefEntry> getReference() {
        return this.reference;
    }

    @Override
    public String toString() {
        if (this.reference != null) {
            return String.format("%s", this.deobfuscatingTranslator.translate((MethodDefEntry)this.reference.context));
        }
        return this.deobfuscatingTranslator.translate(this.entry).getFullName();
    }

    public void load(JarIndex index, boolean recurse) {
        ReferenceIndex referenceIndex = index.getReferenceIndex();
        for (EntryReference<ClassEntry, MethodDefEntry> reference : referenceIndex.getReferencesToClass(this.entry)) {
            this.add(new ClassReferenceTreeNode(this.deobfuscatingTranslator, reference));
        }
        if (recurse && this.children != null) {
            for (EntryReference<ClassEntry, MethodDefEntry> child : this.children) {
                if (!(child instanceof ClassReferenceTreeNode)) continue;
                ClassReferenceTreeNode node = (ClassReferenceTreeNode)((Object)child);
                HashSet<ClassEntry> ancestors = new HashSet<ClassEntry>();
                TreeNode n = node;
                while (n.getParent() != null) {
                    if (!((n = n.getParent()) instanceof ClassReferenceTreeNode)) continue;
                    ancestors.add(((ClassReferenceTreeNode)n).getEntry());
                }
                if (ancestors.contains(node.getEntry())) continue;
                node.load(index, true);
            }
        }
    }
}

