/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.translation.mapping;

import cuchaz.enigma.utils.validation.Message;
import cuchaz.enigma.utils.validation.StandardValidation;
import cuchaz.enigma.utils.validation.ValidationContext;
import java.util.List;

public final class IdentifierValidation {
    private static final List<String> ILLEGAL_IDENTIFIERS = List.of("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while", "_");

    private IdentifierValidation() {
    }

    public static boolean validateClassName(ValidationContext vc, String name, boolean isInner) {
        String[] parts;
        if (!StandardValidation.notBlank(vc, name)) {
            return false;
        }
        if (isInner) {
            return IdentifierValidation.validateIdentifier(vc, name);
        }
        for (String part : parts = name.split("/")) {
            IdentifierValidation.validateIdentifier(vc, part);
        }
        return true;
    }

    public static boolean validateIdentifier(ValidationContext vc, String name) {
        if (!StandardValidation.notBlank(vc, name)) {
            return false;
        }
        if (IdentifierValidation.checkForReservedName(vc, name)) {
            return false;
        }
        int cp = name.codePointAt(0);
        int position = 1;
        if (!Character.isJavaIdentifierStart(cp)) {
            vc.raise(Message.ILLEGAL_IDENTIFIER, name, new String(Character.toChars(cp)), position);
            return false;
        }
        for (int i = Character.charCount(cp); i < name.length(); i += Character.charCount(cp)) {
            cp = name.codePointAt(i);
            ++position;
            if (Character.isJavaIdentifierPart(cp)) continue;
            vc.raise(Message.ILLEGAL_IDENTIFIER, name, new String(Character.toChars(cp)), position);
            return false;
        }
        return true;
    }

    private static boolean checkForReservedName(ValidationContext vc, String name) {
        if (IdentifierValidation.isReservedMethodName(name)) {
            vc.raise(Message.RESERVED_IDENTIFIER, name);
            return true;
        }
        return false;
    }

    public static boolean isReservedMethodName(String name) {
        return ILLEGAL_IDENTIFIERS.contains(name);
    }
}

