/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.jetbrains.java.decompiler.modules.decompiler.SequenceHelper;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.IfExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.DoStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.DummyExitStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.IfStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SequenceStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;

public final class LoopExtractHelper {
    public static boolean extractLoops(Statement root) {
        boolean res;
        boolean bl = res = LoopExtractHelper.extractLoopsRec(root) != 0;
        if (res) {
            SequenceHelper.condenseSequences(root);
        }
        return res;
    }

    private static int extractLoopsRec(Statement stat) {
        boolean updated;
        boolean res = false;
        block0: do {
            updated = false;
            for (Statement st : new ArrayList(stat.getStats())) {
                int extr = LoopExtractHelper.extractLoopsRec(st);
                res |= extr != 0;
                if (extr != 2) continue;
                updated = true;
                continue block0;
            }
        } while (updated);
        if (stat instanceof DoStatement && LoopExtractHelper.extractLoop((DoStatement)stat)) {
            return 2;
        }
        return res ? 1 : 0;
    }

    private static boolean extractLoop(DoStatement stat) {
        if (stat.getLooptype() != DoStatement.Type.INFINITE) {
            return false;
        }
        ArrayList<Statement> stats = new ArrayList<Statement>();
        for (StatEdge edge : stat.getLabelEdges()) {
            if (edge.getType() == 8 || edge.getDestination() instanceof DummyExitStatement) continue;
            if (edge.getType() == 4 && LoopExtractHelper.isExternStatement(stat, edge.getSource(), edge.getSource())) {
                stats.add(edge.getSource());
                continue;
            }
            return false;
        }
        if (!stats.isEmpty() && stat.getParent().getStats().getLast() != stat) {
            return false;
        }
        if (!LoopExtractHelper.extractFirstIf(stat, stats)) {
            return LoopExtractHelper.extractLastIf(stat, stats);
        }
        return true;
    }

    private static boolean extractLastIf(DoStatement stat, List<Statement> stats) {
        Statement last = stat.getFirst();
        while (last instanceof SequenceStatement) {
            last = last.getStats().getLast();
        }
        if (last instanceof IfStatement) {
            IfStatement lastif = (IfStatement)last;
            if (lastif.iftype == 0 && lastif.getIfstat() != null) {
                Statement ifstat = lastif.getIfstat();
                if (lastif.getAllSuccessorEdges().isEmpty()) {
                    return false;
                }
                StatEdge elseedge = lastif.getAllSuccessorEdges().get(0);
                if (elseedge.getType() == 8 && elseedge.closure == stat) {
                    Set<Statement> set = stat.getNeighboursSet(8, Statement.EdgeDirection.BACKWARD);
                    set.remove(last);
                    if (set.isEmpty() && LoopExtractHelper.isExternStatement(stat, ifstat, ifstat)) {
                        Statement first = stat.getFirst();
                        while (first instanceof SequenceStatement) {
                            first = first.getFirst();
                        }
                        if (first instanceof DoStatement && ((DoStatement)first).getLooptype() == DoStatement.Type.INFINITE) {
                            return false;
                        }
                        for (Statement s : stats) {
                            if (ifstat.containsStatement(s)) continue;
                            return false;
                        }
                        LoopExtractHelper.extractIfBlock(stat, lastif);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static boolean extractFirstIf(DoStatement stat, List<Statement> stats) {
        IfStatement firstif;
        Statement first = stat.getFirst();
        while (first instanceof SequenceStatement) {
            first = first.getFirst();
        }
        if (first instanceof IfStatement && (firstif = (IfStatement)first).getFirst().getExprents().isEmpty() && firstif.iftype == 0 && firstif.getIfstat() != null) {
            Statement ifstat = firstif.getIfstat();
            if (LoopExtractHelper.isExternStatement(stat, ifstat, ifstat)) {
                for (Statement s : stats) {
                    if (ifstat.containsStatement(s)) continue;
                    return false;
                }
                LoopExtractHelper.extractIfBlock(stat, firstif);
                return true;
            }
            if (stat.getStats().size() == 1) {
                List<StatEdge> continues = ifstat.getSuccessorEdges(8);
                boolean newDest = false;
                Statement removeFrom = null;
                if (ifstat instanceof SequenceStatement) {
                    removeFrom = ifstat.getStats().getLast();
                    continues.addAll(ifstat.getStats().getLast().getSuccessorEdges(8));
                    newDest = true;
                }
                if (continues.size() == 1 && continues.get(0).getDestination() == stat) {
                    Statement check = stat;
                    while (check.getSuccessorEdges(1).isEmpty()) {
                        if ((check = check.getParent()) != null) continue;
                        return false;
                    }
                    LoopExtractHelper.extractIfBlockIntoLoop(stat, firstif, check.getSuccessorEdges(1).get(0).getDestination());
                    if (newDest) {
                        removeFrom.removeSuccessor(continues.get(0));
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isExternStatement(DoStatement loop, Statement block, Statement stat) {
        for (StatEdge edge : stat.getAllSuccessorEdges()) {
            if (!loop.containsStatement(edge.getDestination()) || block.containsStatement(edge.getDestination())) continue;
            return false;
        }
        for (Statement st : stat.getStats()) {
            if (LoopExtractHelper.isExternStatement(loop, block, st)) continue;
            return false;
        }
        return true;
    }

    private static void extractIfBlock(DoStatement loop, IfStatement ifstat) {
        Statement target = ifstat.getIfstat();
        StatEdge ifedge = ifstat.getIfEdge();
        ifstat.setIfstat(null);
        ifedge.getSource().changeEdgeType(Statement.EdgeDirection.FORWARD, ifedge, 4);
        ifedge.closure = loop;
        ifstat.getStats().removeWithKey(target.id);
        loop.addLabeledEdge(ifedge);
        SequenceStatement block = new SequenceStatement(Arrays.asList(loop, target));
        loop.getParent().replaceStatement(loop, block);
        block.setAllParent();
        loop.addSuccessor(new StatEdge(1, (Statement)loop, target));
        for (StatEdge edge : new ArrayList<StatEdge>(block.getLabelEdges())) {
            if (edge.getType() != 8 && edge != ifedge) continue;
            loop.addLabeledEdge(edge);
        }
        for (StatEdge edge : block.getPredecessorEdges(8)) {
            if (!loop.containsStatementStrict(edge.getSource())) continue;
            block.removePredecessor(edge);
            edge.getSource().changeEdgeNode(Statement.EdgeDirection.FORWARD, edge, loop);
            loop.addPredecessor(edge);
        }
        List<StatEdge> link = target.getPredecessorEdges(4);
        if (link.size() == 1) {
            link.get((int)0).canInline = false;
        }
    }

    private static void extractIfBlockIntoLoop(DoStatement loop, IfStatement ifStat, Statement destination) {
        Statement target = ifStat.getIfstat();
        StatEdge ifedge = ifStat.getIfEdge();
        ifStat.setIfstat(null);
        ifedge.getDestination().removePredecessor(ifedge);
        ifedge.getSource().changeEdgeType(Statement.EdgeDirection.FORWARD, ifedge, 4);
        ifedge.closure = loop;
        ifStat.getStats().removeWithKey(target.id);
        ifedge.setDestination(destination);
        destination.addPredecessor(ifedge);
        loop.addLabeledEdge(ifedge);
        ifStat.setIfEdge(ifedge);
        SequenceStatement block = new SequenceStatement(Arrays.asList(ifStat, target));
        ifStat.replaceWith(block);
        block.setAllParent();
        ifStat.addSuccessor(new StatEdge(1, (Statement)ifStat, target));
        IfExprent expr = ifStat.getHeadexprent();
        expr.setCondition(new FunctionExprent(FunctionExprent.FunctionType.BOOL_NOT, expr.getCondition(), null));
    }
}

