/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.flow;

import java.util.Objects;
import org.jetbrains.java.decompiler.modules.decompiler.ValidationHelper;
import org.jetbrains.java.decompiler.modules.decompiler.flow.DirectEdgeType;
import org.jetbrains.java.decompiler.modules.decompiler.flow.DirectNode;

public final class DirectEdge {
    private final DirectNode source;
    private final DirectNode destination;
    private final DirectEdgeType type;

    public DirectEdge(DirectNode source, DirectNode destination, DirectEdgeType type) {
        ValidationHelper.notNull(source);
        ValidationHelper.notNull(destination);
        ValidationHelper.notNull((Object)type);
        this.source = source;
        this.destination = destination;
        this.type = type;
    }

    public static DirectEdge of(DirectNode source, DirectNode destination) {
        return new DirectEdge(source, destination, DirectEdgeType.REGULAR);
    }

    public static DirectEdge exception(DirectNode source, DirectNode destination) {
        return new DirectEdge(source, destination, DirectEdgeType.EXCEPTION);
    }

    public DirectNode getSource() {
        return this.source;
    }

    public DirectNode getDestination() {
        return this.destination;
    }

    public DirectEdgeType getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DirectEdge that = (DirectEdge)o;
        return this.source.equals(that.source) && this.destination.equals(that.destination) && this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.source, this.destination, this.type});
    }

    public String toString() {
        return "(" + this.source + " -> " + this.destination + " | " + this.type + ")";
    }
}

