/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.network.packet;

import cuchaz.enigma.network.Message;
import cuchaz.enigma.network.ServerPacketHandler;
import cuchaz.enigma.network.packet.EntryChangeS2CPacket;
import cuchaz.enigma.network.packet.Packet;
import cuchaz.enigma.network.packet.PacketHelper;
import cuchaz.enigma.translation.mapping.EntryChange;
import cuchaz.enigma.translation.mapping.EntryRemapper;
import cuchaz.enigma.translation.mapping.EntryUtil;
import cuchaz.enigma.utils.validation.PrintValidatable;
import cuchaz.enigma.utils.validation.Validatable;
import cuchaz.enigma.utils.validation.ValidationContext;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class EntryChangeC2SPacket
implements Packet<ServerPacketHandler> {
    private EntryChange<?> change;

    EntryChangeC2SPacket() {
    }

    public EntryChangeC2SPacket(EntryChange<?> change) {
        this.change = change;
    }

    @Override
    public void read(DataInput input) throws IOException {
        this.change = PacketHelper.readEntryChange(input);
    }

    @Override
    public void write(DataOutput output) throws IOException {
        PacketHelper.writeEntryChange(output, this.change);
    }

    @Override
    public void handle(ServerPacketHandler handler) {
        ValidationContext vc = new ValidationContext();
        vc.setActiveElement((Validatable)PrintValidatable.INSTANCE);
        boolean valid = handler.getServer().canModifyEntry(handler.getClient(), this.change.getTarget());
        if (valid) {
            EntryUtil.applyChange((ValidationContext)vc, null, (EntryRemapper)handler.getServer().getMappings(), this.change);
            valid = vc.canProceed();
        }
        if (!valid) {
            handler.getServer().sendCorrectMapping(handler.getClient(), this.change.getTarget(), true);
            return;
        }
        int syncId = handler.getServer().lockEntry(handler.getClient(), this.change.getTarget());
        handler.getServer().sendToAllExcept(handler.getClient(), new EntryChangeS2CPacket(syncId, this.change));
        if (this.change.getDeobfName().isSet()) {
            handler.getServer().sendMessage(Message.rename(handler.getServer().getUsername(handler.getClient()), this.change.getTarget(), (String)this.change.getDeobfName().getNewValue()));
        } else if (this.change.getDeobfName().isReset()) {
            handler.getServer().sendMessage(Message.removeMapping(handler.getServer().getUsername(handler.getClient()), this.change.getTarget()));
        }
        if (!this.change.getJavadoc().isUnchanged()) {
            handler.getServer().sendMessage(Message.editDocs(handler.getServer().getUsername(handler.getClient()), this.change.getTarget()));
        }
    }
}

