/*
 * Decompiled with CFR 0.152.
 */
package com.github.swingdpi;

import com.github.swingdpi.plaf.JavaVersion;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;

public class DpiUtils {
    public static final int[] STANDARD_SCALINGS = new int[]{100, 125, 150, 200, 250, 300};
    private static final int UNSCALED_DPI = 96;

    public static int getClosestStandardScaling() {
        return DpiUtils.closest(DpiUtils.getSystemScaling(), STANDARD_SCALINGS);
    }

    public static int getClosestStandardScaling(int scaling) {
        return DpiUtils.closest(scaling, STANDARD_SCALINGS);
    }

    public static int getSystemScaling() {
        if (DpiUtils.isPerMonitorDpiActive()) {
            return 100;
        }
        return DpiUtils.getJavaIndependentScreenScaling();
    }

    public static boolean isPerMonitorDpiActive() {
        return JavaVersion.isDpiAware() && !"false".equalsIgnoreCase(System.getProperty("sun.java2d.uiScale.enabled"));
    }

    public static int getJavaIndependentScreenScaling() {
        if (GraphicsEnvironment.isHeadless()) {
            return 100;
        }
        int dpi = Toolkit.getDefaultToolkit().getScreenResolution();
        return Math.round((float)dpi * 100.0f / 96.0f);
    }

    private static int closest(int of, int[] in) {
        int min = Integer.MAX_VALUE;
        int closest = of;
        for (int v : in) {
            int diff = Math.abs(v - of);
            if (diff >= min) continue;
            min = diff;
            closest = v;
        }
        return closest;
    }
}

