/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui.dialog;

import cuchaz.enigma.gui.Gui;
import cuchaz.enigma.gui.config.UiConfig;
import cuchaz.enigma.gui.dialog.ProgressDialog;
import cuchaz.enigma.gui.stats.StatsGenerator;
import cuchaz.enigma.gui.stats.StatsMember;
import cuchaz.enigma.gui.stats.StatsResult;
import cuchaz.enigma.gui.util.GridBagConstraintsBuilder;
import cuchaz.enigma.gui.util.ScaleUtil;
import cuchaz.enigma.utils.I18n;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class StatsDialog {
    public static void show(Gui gui) {
        ProgressDialog.runOffThread(gui.getFrame(), listener -> {
            StatsGenerator statsGenerator = new StatsGenerator(gui.getController().project);
            HashMap<StatsMember, StatsResult> results = new HashMap<StatsMember, StatsResult>();
            for (StatsMember member : StatsMember.values()) {
                results.put(member, statsGenerator.generate(listener, Collections.singleton(member), "", false));
            }
            SwingUtilities.invokeLater(() -> StatsDialog.show(gui, results, ""));
        });
    }

    public static void show(Gui gui, Map<StatsMember, StatsResult> results, String packageName) {
        JDialog dialog = new JDialog(gui.getFrame(), packageName.isEmpty() ? I18n.translate("menu.file.stats.title") : I18n.translateFormatted("menu.file.stats.title_filtered", packageName), true);
        Container contentPane = dialog.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraintsBuilder cb = GridBagConstraintsBuilder.create().insets(2);
        HashMap<StatsMember, JCheckBox> checkboxes = new HashMap<StatsMember, JCheckBox>();
        int[] i = new int[]{0};
        results.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(e -> {
            StatsMember m = (StatsMember)((Object)((Object)e.getKey()));
            StatsResult result = (StatsResult)e.getValue();
            JCheckBox checkBox = new JCheckBox(I18n.translate("type." + m.name().toLowerCase(Locale.ROOT)));
            checkboxes.put(m, checkBox);
            contentPane.add((Component)checkBox, cb.pos(0, i[0]).weightX(1.0).anchor(17).build());
            GridBagConstraintsBuilder labels = cb.anchor(13);
            contentPane.add((Component)new JLabel(Integer.toString(result.getMapped())), labels.pos(1, i[0]).build());
            contentPane.add((Component)new JLabel("/"), labels.pos(2, i[0]).build());
            contentPane.add((Component)new JLabel(Integer.toString(result.getTotal())), labels.pos(3, i[0]).build());
            contentPane.add((Component)new JLabel(String.format("%.2f%%", result.getPercentage())), labels.pos(4, i[0]).build());
            i[0] = i[0] + 1;
        });
        GridBagConstraintsBuilder cb1 = cb.pos(0, 0).width(5).weightX(1.0).anchor(17);
        JLabel topLevelPackageOption = new JLabel(I18n.translate("menu.file.stats.top_level_package"));
        contentPane.add((Component)topLevelPackageOption, cb1.pos(0, results.size() + 1).build());
        JTextField topLevelPackage = new JTextField();
        topLevelPackage.setText(UiConfig.getLastTopLevelPackage());
        contentPane.add((Component)topLevelPackage, cb1.pos(0, results.size() + 2).fill(2).build());
        JButton filterButton = new JButton(I18n.translate("menu.file.stats.filter"));
        filterButton.addActionListener(action -> {
            dialog.dispose();
            ProgressDialog.runOffThread(gui.getFrame(), listener -> {
                UiConfig.setLastTopLevelPackage(topLevelPackage.getText());
                UiConfig.save();
                StatsGenerator statsGenerator = new StatsGenerator(gui.getController().project);
                HashMap<StatsMember, StatsResult> filteredResults = new HashMap<StatsMember, StatsResult>();
                for (StatsMember member : StatsMember.values()) {
                    filteredResults.put(member, statsGenerator.generate(listener, Collections.singleton(member), UiConfig.getLastTopLevelPackage(), false));
                }
                SwingUtilities.invokeLater(() -> StatsDialog.show(gui, filteredResults, UiConfig.getLastTopLevelPackage()));
            });
        });
        contentPane.add((Component)filterButton, cb1.pos(0, results.size() + 3).anchor(13).build());
        JCheckBox syntheticParametersOption = new JCheckBox(I18n.translate("menu.file.stats.synthetic_parameters"));
        syntheticParametersOption.setSelected(UiConfig.shouldIncludeSyntheticParameters());
        contentPane.add((Component)syntheticParametersOption, cb1.pos(0, results.size() + 4).build());
        JButton button = new JButton(I18n.translate("menu.file.stats.generate"));
        button.setEnabled(false);
        button.addActionListener(action -> {
            dialog.dispose();
            UiConfig.setLastTopLevelPackage(topLevelPackage.getText());
            UiConfig.setIncludeSyntheticParameters(syntheticParametersOption.isSelected());
            UiConfig.save();
            StatsDialog.generateStats(gui, checkboxes, topLevelPackage.getText(), syntheticParametersOption.isSelected());
        });
        contentPane.add((Component)button, cb1.pos(0, results.size() + 5).weightY(1.0).anchor(16).build());
        checkboxes.forEach((key, value) -> value.addActionListener(action -> {
            if (!button.isEnabled()) {
                button.setEnabled(true);
            } else if (checkboxes.entrySet().stream().noneMatch(entry -> ((JCheckBox)entry.getValue()).isSelected())) {
                button.setEnabled(false);
            }
        }));
        dialog.pack();
        Dimension size = dialog.getSize();
        dialog.setMinimumSize(size);
        size.width = ScaleUtil.scale(350);
        dialog.setSize(size);
        dialog.setLocationRelativeTo(gui.getFrame());
        dialog.setVisible(true);
    }

    private static void generateStats(Gui gui, Map<StatsMember, JCheckBox> checkboxes, String topLevelPackage, boolean includeSynthetic) {
        Set<StatsMember> includedMembers = checkboxes.entrySet().stream().filter(entry -> ((JCheckBox)entry.getValue()).isSelected()).map(Map.Entry::getKey).collect(Collectors.toSet());
        if (gui.getController().project != null) {
            gui.getController().openStats(includedMembers, topLevelPackage, includeSynthetic);
        }
    }
}

