/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui.elements;

import cuchaz.enigma.analysis.ClassTreeNode;
import cuchaz.enigma.analysis.MethodInheritanceTreeNode;
import cuchaz.enigma.analysis.MethodTreeNode;
import cuchaz.enigma.gui.Gui;
import cuchaz.enigma.gui.util.GuiUtil;
import cuchaz.enigma.gui.util.SingleTreeSelectionModel;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.Entry;
import java.awt.BorderLayout;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractInheritanceTree {
    private final JPanel panel = new JPanel(new BorderLayout());
    private final JTree tree = new JTree();
    protected final Gui gui;

    public AbstractInheritanceTree(Gui gui, TreeCellRenderer cellRenderer) {
        this.gui = gui;
        this.tree.setModel(null);
        this.tree.setCellRenderer(cellRenderer);
        this.tree.setSelectionModel(new SingleTreeSelectionModel());
        this.tree.setShowsRootHandles(true);
        this.tree.addMouseListener(GuiUtil.onMouseClick(this::onClick));
        this.panel.add(new JScrollPane(this.tree));
    }

    private void onClick(MouseEvent event) {
        if (event.getClickCount() >= 2 && event.getButton() == 1) {
            TreePath path = this.tree.getSelectionPath();
            if (path == null) {
                return;
            }
            Object node = path.getLastPathComponent();
            if (node instanceof ClassTreeNode) {
                ClassTreeNode classNode = (ClassTreeNode)node;
                this.gui.getController().navigateTo(new ClassEntry(classNode.getClassEntry().getFullName()));
            } else if (node instanceof MethodTreeNode) {
                MethodInheritanceTreeNode inheritanceMethodNode;
                MethodTreeNode methodNode = (MethodTreeNode)node;
                if (methodNode instanceof MethodInheritanceTreeNode && !(inheritanceMethodNode = (MethodInheritanceTreeNode)methodNode).isImplemented()) {
                    return;
                }
                this.gui.getController().navigateTo(methodNode.getMethodEntry());
            }
        }
    }

    public void display(Entry<?> entry) {
        this.tree.setModel(null);
        DefaultMutableTreeNode node = this.getNodeFor(entry);
        if (node != null) {
            TreePath path = GuiUtil.getPathToRoot(node);
            this.tree.setModel(new DefaultTreeModel((TreeNode)path.getPathComponent(0)));
            this.tree.expandPath(path);
            this.tree.setSelectionRow(this.tree.getRowForPath(path));
        }
        this.panel.show();
    }

    public void retranslateUi() {
    }

    @Nullable
    protected abstract DefaultMutableTreeNode getNodeFor(Entry<?> var1);

    protected abstract String getPanelName();

    public JPanel getPanel() {
        return this.panel;
    }
}

