/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui.elements;

import cuchaz.enigma.api.service.GuiService;
import cuchaz.enigma.gui.util.EnigmaIconImpl;
import cuchaz.enigma.gui.util.ScaleUtil;
import java.awt.Cursor;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JButton;

public class GutterIcon
extends JButton
implements GuiService.GutterMarkerBuilder {
    private Runnable clickAction = () -> {};

    public GutterIcon(final EnigmaIconImpl icon) {
        super(icon.icon());
        this.setContentAreaFilled(false);
        this.setCursor(Cursor.getDefaultCursor());
        this.addActionListener(e -> this.clickAction.run());
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                GutterIcon.this.setIcon(icon.icon().derive(ScaleUtil.invert(GutterIcon.this.getWidth()), ScaleUtil.invert(GutterIcon.this.getHeight())));
            }
        });
    }

    @Override
    public GuiService.GutterMarkerBuilder setClickAction(Runnable action) {
        this.clickAction = action;
        this.setCursor(Cursor.getPredefinedCursor(12));
        return this;
    }

    @Override
    public GuiService.GutterMarkerBuilder setTooltip(String tooltip) {
        this.setToolTipText(tooltip);
        return this;
    }
}

