/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui.panels;

import cuchaz.enigma.gui.ClassSelector;
import cuchaz.enigma.gui.Gui;
import cuchaz.enigma.gui.elements.DeobfPanelPopupMenu;
import cuchaz.enigma.gui.util.GuiUtil;
import cuchaz.enigma.utils.I18n;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class DeobfPanel
extends JPanel {
    public final ClassSelector deobfClasses;
    private final JLabel title = new JLabel();
    public final DeobfPanelPopupMenu deobfPanelPopupMenu;
    private final Gui gui;

    public DeobfPanel(Gui gui) {
        this.gui = gui;
        this.deobfClasses = new ClassSelector(gui, ClassSelector.DEOBF_CLASS_COMPARATOR, true);
        this.deobfClasses.setSelectionListener(gui.getController()::navigateTo);
        this.deobfClasses.setRenameSelectionListener(gui::onRenameFromClassTree);
        this.deobfPanelPopupMenu = new DeobfPanelPopupMenu(this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.title, "North");
        this.add((Component)new JScrollPane(this.deobfClasses), "Center");
        this.deobfClasses.addMouseListener(GuiUtil.onMousePress(this::onPress));
        this.retranslateUi();
    }

    private void onPress(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e)) {
            this.deobfClasses.setSelectionRow(this.deobfClasses.getClosestRowForLocation(e.getX(), e.getY()));
            int i = this.deobfClasses.getRowForPath(this.deobfClasses.getSelectionPath());
            if (i != -1) {
                this.deobfPanelPopupMenu.show(this.deobfClasses, e.getX(), e.getY());
            }
        }
    }

    public void retranslateUi() {
        this.title.setText(I18n.translate(this.gui.isSingleClassTree() ? "info_panel.classes" : "info_panel.classes.deobfuscated"));
        this.deobfPanelPopupMenu.retranslateUi();
    }
}

