/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.source;

import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.source.SourceRemapper;
import cuchaz.enigma.source.Token;
import cuchaz.enigma.translation.Translatable;
import cuchaz.enigma.translation.mapping.EntryResolver;
import cuchaz.enigma.translation.mapping.ResolutionStrategy;
import cuchaz.enigma.translation.representation.entry.Entry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.Nullable;

public class SourceIndex {
    private String source;
    private List<Integer> lineOffsets;
    private final TreeMap<Token, EntryReference<Entry<?>, Entry<?>>> tokenToReference = new TreeMap();
    private final Map<EntryReference<Entry<?>, Entry<?>>, Collection<Token>> referenceToTokens = new HashMap();
    private final TreeMap<Token, Entry<?>> tokenToDeclaration = new TreeMap();
    private final Map<Entry<?>, Token> declarationToToken = new HashMap();

    public SourceIndex() {
    }

    public SourceIndex(String source) {
        this();
        this.setSource(source);
    }

    public void setSource(String source) {
        this.source = source;
        this.lineOffsets = new ArrayList<Integer>();
        this.lineOffsets.add(0);
        for (int i = 0; i < this.source.length(); ++i) {
            if (this.source.charAt(i) != '\n') continue;
            this.lineOffsets.add(i + 1);
        }
    }

    public String getSource() {
        return this.source;
    }

    public int getLineNumber(int position) {
        int offset;
        int line = 0;
        Iterator<Integer> iterator = this.lineOffsets.iterator();
        while (iterator.hasNext() && (offset = iterator.next().intValue()) <= position) {
            ++line;
        }
        return line;
    }

    public int getColumnNumber(int position) {
        return position - this.lineOffsets.get(this.getLineNumber(position) - 1) + 1;
    }

    public int getPosition(int line, int column) {
        return this.lineOffsets.get(line - 1) + column - 1;
    }

    public Iterable<Entry<?>> declarations() {
        return this.declarationToToken.keySet();
    }

    public Iterable<Token> declarationTokens() {
        return this.declarationToToken.values();
    }

    public Token getDeclarationToken(Entry<?> entry) {
        return this.declarationToToken.get(entry);
    }

    @Nullable
    public Entry<?> getDeclaration(Token token) {
        return this.tokenToDeclaration.get(token);
    }

    public void addDeclaration(Token token, Entry<?> deobfEntry) {
        if (token != null) {
            EntryReference reference = new EntryReference(deobfEntry, token.text);
            this.tokenToReference.put(token, reference);
            this.referenceToTokens.computeIfAbsent(reference, key -> new ArrayList()).add(token);
            this.referenceToTokens.computeIfAbsent(EntryReference.declaration(deobfEntry, token.text), key -> new ArrayList()).add(token);
            this.tokenToDeclaration.put(token, deobfEntry);
            this.declarationToToken.put(deobfEntry, token);
        }
    }

    public Iterable<EntryReference<Entry<?>, Entry<?>>> references() {
        return this.referenceToTokens.keySet();
    }

    public EntryReference<Entry<?>, Entry<?>> getReference(Token token) {
        if (token == null) {
            return null;
        }
        return this.tokenToReference.get(token);
    }

    public Iterable<Token> referenceTokens() {
        return this.tokenToReference.keySet();
    }

    @Nullable
    public Token getReferenceToken(int pos) {
        Token token = this.tokenToReference.floorKey(new Token(pos, pos, null));
        if (token != null && token.contains(pos)) {
            return token;
        }
        return null;
    }

    public Collection<Token> getReferenceTokens(EntryReference<Entry<?>, Entry<?>> deobfReference) {
        return this.referenceToTokens.getOrDefault(deobfReference, List.of());
    }

    public void addReference(Token token, Entry<?> deobfEntry, Entry<?> deobfContext) {
        if (token != null) {
            EntryReference deobfReference = new EntryReference(deobfEntry, token.text, deobfContext);
            this.tokenToReference.put(token, deobfReference);
            this.referenceToTokens.computeIfAbsent(deobfReference, key -> new ArrayList()).add(token);
        }
    }

    public void resolveReferences(EntryResolver resolver) {
        for (Token token : this.referenceToTokens.values().stream().flatMap(Collection::stream).toList()) {
            EntryReference<Entry<?>, Entry<?>> reference = this.tokenToReference.get(token);
            EntryReference<Entry<?>, Entry<?>> resolvedReference = resolver.resolveFirstReference(reference, ResolutionStrategy.RESOLVE_CLOSEST);
            this.tokenToReference.replace(token, resolvedReference);
            Collection<Token> tokens = this.referenceToTokens.remove(reference);
            if (tokens == null) continue;
            this.referenceToTokens.computeIfAbsent(resolvedReference, key -> new ArrayList()).addAll(tokens);
        }
    }

    public SourceIndex remapTo(SourceRemapper.Result result) {
        SourceIndex remapped = new SourceIndex(result.getSource());
        for (Map.Entry<Entry<?>, Token> entry : this.declarationToToken.entrySet()) {
            Token remappedToken = result.getRemappedToken(entry.getValue());
            remapped.declarationToToken.put(entry.getKey(), remappedToken);
            remapped.tokenToDeclaration.put(remappedToken, entry.getKey());
        }
        for (Map.Entry<Translatable, Object> entry : this.referenceToTokens.entrySet()) {
            EntryReference reference = (EntryReference)entry.getKey();
            Collection oldTokens = (Collection)entry.getValue();
            List<Token> newTokens = oldTokens.stream().map(result::getRemappedToken).toList();
            remapped.referenceToTokens.computeIfAbsent(reference, key -> new ArrayList()).addAll(newTokens);
        }
        for (Map.Entry<Object, Object> entry : this.tokenToReference.entrySet()) {
            remapped.tokenToReference.put(result.getRemappedToken((Token)entry.getKey()), (EntryReference)entry.getValue());
        }
        return remapped;
    }
}

