/*
 * Decompiled with CFR 0.152.
 */
package org.benf.cfr.reader.entities.attributes;

import java.util.Collections;
import java.util.List;
import org.benf.cfr.reader.entities.attributes.Attribute;
import org.benf.cfr.reader.entities.constantpool.ConstantPool;
import org.benf.cfr.reader.entityfactories.AttributeFactory;
import org.benf.cfr.reader.entityfactories.ContiguousEntityFactory;
import org.benf.cfr.reader.util.ClassFileVersion;
import org.benf.cfr.reader.util.bytestream.ByteData;
import org.benf.cfr.reader.util.collections.ListFactory;
import org.benf.cfr.reader.util.output.Dumper;

public class AttributeRecord
extends Attribute {
    public static final String ATTRIBUTE_NAME = "Record";
    private static final long OFFSET_OF_ATTRIBUTE_LENGTH = 2L;
    private static final long OFFSET_OF_REMAINDER = 6L;
    private final int length;
    private final List<RecordComponentInfo> componentInfos;

    public AttributeRecord(ByteData raw, ConstantPool cp, ClassFileVersion classFileVersion) {
        this.length = raw.getS4At(2L);
        int numComponents = raw.getU2At(6L);
        long offset = 8L;
        this.componentInfos = ListFactory.newList();
        for (int i = 0; i < numComponents; ++i) {
            short nameIndex = raw.getS2At(offset);
            String name = cp.getUTF8Entry(nameIndex).getValue();
            short descriptorIndex = raw.getS2At(offset += 2L);
            String descriptor = cp.getUTF8Entry(descriptorIndex).getValue();
            short attributesCount = raw.getS2At(offset += 2L);
            List<Attribute> attributes = ListFactory.newList();
            raw = raw.getOffsetData(offset += 2L);
            offset = ContiguousEntityFactory.build(raw, attributesCount, attributes, AttributeFactory.getBuilder(cp, classFileVersion));
            this.componentInfos.add(new RecordComponentInfo(name, descriptor, attributes));
        }
    }

    public List<Attribute> getRecordComponentAttributes(String componentName) {
        for (RecordComponentInfo componentInfo : this.componentInfos) {
            if (!componentInfo.getName().equals(componentName)) continue;
            return componentInfo.getAttributes();
        }
        return Collections.emptyList();
    }

    @Override
    public long getRawByteLength() {
        return 6L + (long)this.length;
    }

    @Override
    public String getRawName() {
        return ATTRIBUTE_NAME;
    }

    @Override
    public Dumper dump(Dumper d) {
        return d.print(ATTRIBUTE_NAME);
    }

    public static class RecordComponentInfo {
        private final String name;
        private final String descriptor;
        private final List<Attribute> attributes;

        public RecordComponentInfo(String name, String descriptor, List<Attribute> attributes) {
            this.name = name;
            this.descriptor = descriptor;
            this.attributes = attributes;
        }

        public String getName() {
            return this.name;
        }

        public String getDescriptor() {
            return this.descriptor;
        }

        public List<Attribute> getAttributes() {
            return Collections.unmodifiableList(this.attributes);
        }
    }
}

