/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.modules.decompiler.ConcatenationHelper;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ArrayExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.IfExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.InvocationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.IfStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.struct.gen.CodeType;
import org.jetbrains.java.decompiler.struct.gen.VarType;

public final class SecondaryFunctionsHelper {
    private static final IdentifySecondaryOptions DEFAULT_OPTIONS = new IdentifySecondaryOptions();
    private static final Map<FunctionExprent.FunctionType, FunctionExprent.FunctionType> funcsnot = new HashMap<FunctionExprent.FunctionType, FunctionExprent.FunctionType>();
    private static final HashMap<FunctionExprent.FunctionType, FunctionExprent.FunctionType[]> mapNumComparisons;

    public static boolean identifySecondaryFunctions(Statement stat, VarProcessor varProc) {
        return SecondaryFunctionsHelper.identifySecondaryFunctions(stat, varProc, DEFAULT_OPTIONS);
    }

    public static boolean identifySecondaryFunctions(Statement stat, VarProcessor varProc, IdentifySecondaryOptions options) {
        if (stat.getExprents() == null && stat instanceof IfStatement) {
            IfStatement ifelsestat = (IfStatement)stat;
            Statement ifstat = ifelsestat.getIfstat();
            if (ifelsestat.iftype == 1 && ifstat.getExprents() != null && ifstat.getExprents().isEmpty() && (ifstat.getAllSuccessorEdges().isEmpty() || !ifstat.getFirstSuccessor().explicit)) {
                ifelsestat.getStats().removeWithKey(ifstat.id);
                ifelsestat.iftype = 0;
                ifelsestat.setIfstat(ifelsestat.getElsestat());
                ifelsestat.setElsestat(null);
                if (ifelsestat.getAllSuccessorEdges().isEmpty() && !ifstat.getAllSuccessorEdges().isEmpty()) {
                    StatEdge endedge = ifstat.getFirstSuccessor();
                    ifstat.removeSuccessor(endedge);
                    endedge.setSource(ifelsestat);
                    if (endedge.closure != null) {
                        ifelsestat.getParent().addLabeledEdge(endedge);
                    }
                    ifelsestat.addSuccessor(endedge);
                }
                ifelsestat.getFirst().removeSuccessor(ifelsestat.getIfEdge());
                ifelsestat.setIfEdge(ifelsestat.getElseEdge());
                ifelsestat.setElseEdge(null);
                ifelsestat.setNegated(!ifelsestat.isNegated());
                ifelsestat.getHeadexprentList().set(0, ((IfExprent)ifelsestat.getHeadexprent().copy()).negateIf());
                return true;
            }
            if (ifelsestat.iftype != 0 || ifstat == null || ifstat.getExprents() == null || !ifstat.getExprents().isEmpty() || !ifstat.hasAnySuccessor() || ifstat.getFirstSuccessor().getType() == 32) {
                // empty if block
            }
        }
        boolean ret = false;
        boolean replaced = true;
        block0: while (replaced) {
            replaced = false;
            ArrayList<Object> lstObjects = new ArrayList<Object>(stat.getExprents() == null ? stat.getSequentialObjects() : stat.getExprents());
            for (int i = 0; i < lstObjects.size(); ++i) {
                Exprent retexpr;
                Object obj = lstObjects.get(i);
                if (obj instanceof Statement) {
                    if (!SecondaryFunctionsHelper.identifySecondaryFunctions((Statement)obj, varProc, options)) continue;
                    ret = true;
                    replaced = true;
                    continue block0;
                }
                if (!(obj instanceof Exprent) || (retexpr = SecondaryFunctionsHelper.identifySecondaryFunctions((Exprent)obj, true, varProc, options)) == null) continue;
                if (stat.getExprents() == null) {
                    stat.replaceExprent((Exprent)obj, retexpr);
                } else {
                    stat.getExprents().set(i, retexpr);
                }
                ret = true;
                replaced = true;
                continue block0;
            }
        }
        return ret;
    }

    private static Exprent identifySecondaryFunctions(Exprent exprent, boolean statement_level, VarProcessor varProc, IdentifySecondaryOptions options) {
        Exprent ret;
        block52: {
            ConstExprent cexpr;
            if (exprent instanceof FunctionExprent) {
                FunctionExprent fexpr = (FunctionExprent)exprent;
                switch (fexpr.getFuncType()) {
                    case BOOL_NOT: {
                        Exprent retparam = SecondaryFunctionsHelper.propagateBoolNot(fexpr);
                        if (retparam == null) break;
                        return retparam;
                    }
                    case EQ: 
                    case NE: 
                    case GT: 
                    case GE: 
                    case LT: 
                    case LE: {
                        FunctionExprent.FunctionType destcon;
                        int index;
                        Object expr1 = fexpr.getLstOperands().get(0);
                        Object expr2 = fexpr.getLstOperands().get(1);
                        if (expr1 instanceof ConstExprent) {
                            expr2 = expr1;
                            expr1 = fexpr.getLstOperands().get(1);
                        }
                        if (!(expr1 instanceof FunctionExprent) || !(expr2 instanceof ConstExprent)) break;
                        FunctionExprent funcexpr = (FunctionExprent)expr1;
                        cexpr = (ConstExprent)expr2;
                        FunctionExprent.FunctionType functype = funcexpr.getFuncType();
                        if (functype != FunctionExprent.FunctionType.LCMP && functype != FunctionExprent.FunctionType.FCMPG && functype != FunctionExprent.FunctionType.FCMPL && functype != FunctionExprent.FunctionType.DCMPG && functype != FunctionExprent.FunctionType.DCMPL) break;
                        FunctionExprent.FunctionType desttype = null;
                        FunctionExprent.FunctionType[] destcons = mapNumComparisons.get(fexpr.getFuncType());
                        if (destcons != null && (index = cexpr.getIntValue() + 1) >= 0 && index <= 2 && (destcon = destcons[index]) != null) {
                            desttype = destcon;
                        }
                        if (desttype == null) break;
                        if (functype != FunctionExprent.FunctionType.LCMP) {
                            boolean trueForNan;
                            boolean oneForNan = functype == FunctionExprent.FunctionType.DCMPL || functype == FunctionExprent.FunctionType.FCMPL;
                            boolean trueForOne = desttype == FunctionExprent.FunctionType.LT || desttype == FunctionExprent.FunctionType.LE;
                            boolean bl = trueForNan = oneForNan == trueForOne;
                            if (trueForNan) {
                                ArrayList<Exprent> operands = new ArrayList<Exprent>();
                                operands.add(new FunctionExprent(funcsnot.get(desttype), funcexpr.getLstOperands(), funcexpr.bytecode));
                                return new FunctionExprent(FunctionExprent.FunctionType.BOOL_NOT, operands, funcexpr.bytecode);
                            }
                        }
                        return new FunctionExprent(desttype, funcexpr.getLstOperands(), funcexpr.bytecode);
                    }
                    case PPI: {
                        if (!statement_level) break;
                        FunctionExprent func = new FunctionExprent(FunctionExprent.FunctionType.IPP, fexpr.getLstOperands(), fexpr.bytecode);
                        func.setImplicitType(fexpr.getExprType());
                        return func;
                    }
                    case MMI: {
                        if (!statement_level) break;
                        FunctionExprent func = new FunctionExprent(FunctionExprent.FunctionType.IMM, fexpr.getLstOperands(), fexpr.bytecode);
                        func.setImplicitType(fexpr.getExprType());
                        return func;
                    }
                }
            }
            ret = null;
            boolean replaced = true;
            block22: while (replaced) {
                replaced = false;
                for (Exprent expr : exprent.getAllExprents()) {
                    Exprent retexpr = SecondaryFunctionsHelper.identifySecondaryFunctions(expr, false, varProc, options);
                    if (retexpr == null) continue;
                    exprent.replaceExprent(expr, retexpr);
                    retexpr.addBytecodeOffsets(expr.bytecode);
                    replaced = true;
                    ret = exprent;
                    continue block22;
                }
            }
            block6 : switch (exprent.type) {
                case FUNCTION: {
                    FunctionExprent fexpr = (FunctionExprent)exprent;
                    List<Exprent> lstOperands = fexpr.getLstOperands();
                    switch (fexpr.getFuncType()) {
                        case XOR: {
                            for (int i = 0; i < 2; ++i) {
                                Exprent operand = lstOperands.get(i);
                                VarType operandtype = operand.getExprType();
                                if (!(operand instanceof ConstExprent) || operandtype.type == CodeType.BOOLEAN) continue;
                                ConstExprent cexpr2 = (ConstExprent)operand;
                                long val = operandtype.type == CodeType.LONG ? (Long)cexpr2.getValue() : (long)((Integer)cexpr2.getValue()).intValue();
                                if (val != -1L) continue;
                                ArrayList<Exprent> lstBitNotOperand = new ArrayList<Exprent>();
                                lstBitNotOperand.add(lstOperands.get(1 - i));
                                return new FunctionExprent(FunctionExprent.FunctionType.BIT_NOT, lstBitNotOperand, fexpr.bytecode);
                            }
                            break block6;
                        }
                        case EQ: 
                        case NE: {
                            if (lstOperands.get((int)0).getExprType().type == CodeType.BOOLEAN && lstOperands.get((int)1).getExprType().type == CodeType.BOOLEAN) {
                                for (int i = 0; i < 2; ++i) {
                                    if (!(lstOperands.get(i) instanceof ConstExprent)) continue;
                                    cexpr = (ConstExprent)lstOperands.get(i);
                                    int val = (Integer)cexpr.getValue();
                                    if (fexpr.getFuncType() == FunctionExprent.FunctionType.EQ && val == 1 || fexpr.getFuncType() == FunctionExprent.FunctionType.NE && val == 0) {
                                        return lstOperands.get(1 - i);
                                    }
                                    ArrayList<Exprent> lstNotOperand = new ArrayList<Exprent>();
                                    lstNotOperand.add(lstOperands.get(1 - i));
                                    return new FunctionExprent(FunctionExprent.FunctionType.BOOL_NOT, lstNotOperand, fexpr.bytecode);
                                }
                                break block6;
                            }
                            break block52;
                        }
                        case BOOL_NOT: {
                            if (lstOperands.get(0) instanceof ConstExprent) {
                                int val = ((ConstExprent)lstOperands.get(0)).getIntValue();
                                if (val == 0) {
                                    return new ConstExprent(VarType.VARTYPE_BOOLEAN, 1, fexpr.bytecode);
                                }
                                return new ConstExprent(VarType.VARTYPE_BOOLEAN, 0, fexpr.bytecode);
                            }
                            break block52;
                        }
                        case TERNARY: {
                            ConstExprent cexpr1;
                            Exprent expr0 = lstOperands.get(0);
                            Exprent expr1 = lstOperands.get(1);
                            Exprent expr2 = lstOperands.get(2);
                            if (expr1 instanceof ConstExprent && expr2 instanceof ConstExprent) {
                                cexpr1 = (ConstExprent)expr1;
                                ConstExprent cexpr2 = (ConstExprent)expr2;
                                if (cexpr1.getExprType().type == CodeType.BOOLEAN && cexpr2.getExprType().type == CodeType.BOOLEAN) {
                                    if (cexpr1.getIntValue() == 0 && cexpr2.getIntValue() != 0) {
                                        return new FunctionExprent(FunctionExprent.FunctionType.BOOL_NOT, lstOperands.get(0), fexpr.bytecode);
                                    }
                                    if (cexpr1.getIntValue() != 0 && cexpr2.getIntValue() == 0) {
                                        return lstOperands.get(0);
                                    }
                                }
                            }
                            if (DecompilerContext.getOption("ternary-constant-simplification") || options.forceTernarySimplification) {
                                if (expr1 instanceof ConstExprent && expr1.getExprType().type == CodeType.BOOLEAN) {
                                    boolean val;
                                    cexpr1 = (ConstExprent)expr1;
                                    boolean bl = val = cexpr1.getIntValue() != 0;
                                    if (val) {
                                        return new FunctionExprent(FunctionExprent.FunctionType.BOOLEAN_OR, Arrays.asList(lstOperands.get(0), lstOperands.get(2)), fexpr.bytecode);
                                    }
                                    FunctionExprent fnot = new FunctionExprent(FunctionExprent.FunctionType.BOOL_NOT, lstOperands.get(0), fexpr.bytecode);
                                    return new FunctionExprent(FunctionExprent.FunctionType.BOOLEAN_AND, Arrays.asList(fnot, lstOperands.get(2)), fexpr.bytecode);
                                }
                                if (expr2 instanceof ConstExprent && expr2.getExprType().type == CodeType.BOOLEAN) {
                                    boolean val;
                                    ConstExprent cexpr2 = (ConstExprent)expr2;
                                    boolean bl = val = cexpr2.getIntValue() != 0;
                                    if (val) {
                                        FunctionExprent fnot = new FunctionExprent(FunctionExprent.FunctionType.BOOL_NOT, lstOperands.get(0), fexpr.bytecode);
                                        return new FunctionExprent(FunctionExprent.FunctionType.BOOLEAN_OR, Arrays.asList(fnot, lstOperands.get(1)), fexpr.bytecode);
                                    }
                                    return new FunctionExprent(FunctionExprent.FunctionType.BOOLEAN_AND, Arrays.asList(lstOperands.get(0), lstOperands.get(1)), fexpr.bytecode);
                                }
                                if (expr1.getExprType().type == CodeType.BOOLEAN && expr1.equals(expr0)) {
                                    return new FunctionExprent(FunctionExprent.FunctionType.BOOLEAN_OR, Arrays.asList(lstOperands.get(0), lstOperands.get(2)), fexpr.bytecode);
                                }
                                if (expr2.getExprType().type == CodeType.BOOLEAN && expr2.equals(expr0)) {
                                    return new FunctionExprent(FunctionExprent.FunctionType.BOOLEAN_AND, Arrays.asList(lstOperands.get(0), lstOperands.get(1)), fexpr.bytecode);
                                }
                            }
                            break block52;
                        }
                        case LCMP: 
                        case FCMPL: 
                        case FCMPG: 
                        case DCMPL: 
                        case DCMPG: {
                            int var = DecompilerContext.getCounterContainer().getCounterAndIncrement(2);
                            VarType type = lstOperands.get(0).getExprType();
                            FunctionExprent iff = new FunctionExprent(FunctionExprent.FunctionType.TERNARY, Arrays.asList(new FunctionExprent(FunctionExprent.FunctionType.LT, Arrays.asList(new VarExprent(var, type, varProc), ConstExprent.getZeroConstant(type.type)), null), new ConstExprent(VarType.VARTYPE_INT, -1, null), new ConstExprent(VarType.VARTYPE_INT, 1, null)), null);
                            FunctionExprent head = new FunctionExprent(FunctionExprent.FunctionType.EQ, Arrays.asList(new AssignmentExprent(new VarExprent(var, type, varProc), new FunctionExprent(FunctionExprent.FunctionType.SUB, Arrays.asList(lstOperands.get(0), lstOperands.get(1)), null), null), ConstExprent.getZeroConstant(type.type)), null);
                            varProc.setVarType(new VarVersionPair(var, 0), type);
                            return new FunctionExprent(FunctionExprent.FunctionType.TERNARY, Arrays.asList(head, new ConstExprent(VarType.VARTYPE_INT, 0, null), iff), fexpr.bytecode);
                        }
                    }
                    break;
                }
                case ASSIGNMENT: {
                    AssignmentExprent asexpr = (AssignmentExprent)exprent;
                    if (asexpr.getCondType() != null) {
                        return ret;
                    }
                    Exprent right = asexpr.getRight();
                    Exprent left = asexpr.getLeft();
                    if (!(right instanceof FunctionExprent)) break;
                    FunctionExprent func = (FunctionExprent)right;
                    if (!SecondaryFunctionsHelper.isSimple(left, null)) break;
                    VarType midlayer = null;
                    if (func.getFuncType().castType != null) {
                        right = func.getLstOperands().get(0);
                        midlayer = func.getSimpleCastType();
                        if (right instanceof FunctionExprent) {
                            func = (FunctionExprent)right;
                        } else {
                            return ret;
                        }
                    }
                    List<Exprent> lstFuncOperands = func.getLstOperands();
                    Exprent cond = null;
                    switch (func.getFuncType()) {
                        case XOR: 
                        case ADD: 
                        case AND: 
                        case OR: {
                            if (left.equals(lstFuncOperands.get(1))) {
                                cond = lstFuncOperands.get(0);
                                break;
                            }
                        }
                        case SUB: 
                        case MUL: 
                        case DIV: 
                        case REM: 
                        case SHL: 
                        case SHR: 
                        case USHR: {
                            if (!left.equals(lstFuncOperands.get(0))) break;
                            cond = lstFuncOperands.get(1);
                        }
                    }
                    if (cond == null || midlayer != null && !midlayer.equals(cond.getExprType()) || !SecondaryFunctionsHelper.isSimple(left, cond)) break;
                    asexpr.setRight(cond);
                    asexpr.setCondType(func.getFuncType());
                    ret = exprent;
                    break;
                }
                case INVOCATION: {
                    if (!statement_level) {
                        Exprent retexpr = ConcatenationHelper.contractStringConcat(exprent);
                        if (exprent.equals(retexpr)) break;
                        return retexpr;
                    }
                    InvocationExprent invocationExprent = (InvocationExprent)exprent;
                    if (!invocationExprent.isBoxingCall()) break;
                    invocationExprent.forceBoxing(true);
                }
            }
        }
        return ret;
    }

    private static boolean isSimple(Exprent exprent, Exprent other) {
        switch (exprent.type) {
            case VAR: 
            case CONST: {
                return true;
            }
            case ARRAY: {
                ArrayExprent array = (ArrayExprent)exprent;
                return SecondaryFunctionsHelper.isSuperSimple(array.getIndex()) && SecondaryFunctionsHelper.isSuperSimple(array.getArray());
            }
            case FIELD: {
                if (other == null) {
                    return true;
                }
                return (other.getExprentUse() & 2) != 0;
            }
        }
        return false;
    }

    private static boolean isSuperSimple(Exprent exprent) {
        return exprent.type == Exprent.Type.VAR || exprent.type == Exprent.Type.CONST;
    }

    public static Exprent propagateBoolNot(Exprent exprent) {
        Exprent param;
        FunctionExprent fexpr;
        if (exprent instanceof FunctionExprent && (fexpr = (FunctionExprent)exprent).getFuncType() == FunctionExprent.FunctionType.BOOL_NOT && (param = fexpr.getLstOperands().get(0)) instanceof FunctionExprent) {
            FunctionExprent fparam = (FunctionExprent)param;
            FunctionExprent.FunctionType ftype = fparam.getFuncType();
            boolean canSimplify = false;
            switch (ftype) {
                case BOOL_NOT: {
                    Exprent newexpr = fparam.getLstOperands().get(0);
                    Exprent retexpr = SecondaryFunctionsHelper.propagateBoolNot(newexpr);
                    return retexpr == null ? newexpr : retexpr;
                }
                case TERNARY: {
                    FunctionExprent fex1 = new FunctionExprent(FunctionExprent.FunctionType.BOOL_NOT, fparam.getLstOperands().get(1), null);
                    FunctionExprent fex2 = new FunctionExprent(FunctionExprent.FunctionType.BOOL_NOT, fparam.getLstOperands().get(2), null);
                    Exprent ex1 = SecondaryFunctionsHelper.propagateBoolNot(fex1);
                    Exprent ex2 = SecondaryFunctionsHelper.propagateBoolNot(fex2);
                    fparam.getLstOperands().set(1, ex1 == null ? fex1 : ex1);
                    fparam.getLstOperands().set(2, ex2 == null ? fex2 : ex2);
                    return fparam;
                }
                case BOOLEAN_AND: 
                case BOOLEAN_OR: {
                    List<Exprent> operands = fparam.getLstOperands();
                    for (int i = 0; i < operands.size(); ++i) {
                        FunctionExprent newparam = new FunctionExprent(FunctionExprent.FunctionType.BOOL_NOT, operands.get(i), operands.get((int)i).bytecode);
                        Exprent retparam = SecondaryFunctionsHelper.propagateBoolNot(newparam);
                        operands.set(i, retparam == null ? newparam : retparam);
                    }
                }
                case EQ: 
                case NE: {
                    canSimplify = true;
                }
                case GT: 
                case GE: 
                case LT: 
                case LE: {
                    VarType right;
                    VarType left;
                    VarType commonSupertype;
                    List<Exprent> operands;
                    if (!canSimplify && (commonSupertype = VarType.getCommonSupertype(left = (operands = fparam.getLstOperands()).get(0).getExprType(), right = operands.get(1).getExprType())) != null) {
                        boolean bl = canSimplify = commonSupertype.type != CodeType.FLOAT && commonSupertype.type != CodeType.DOUBLE;
                    }
                    if (!canSimplify) break;
                    fparam.setFuncType(funcsnot.get(ftype));
                    return fparam;
                }
            }
        }
        return null;
    }

    public static boolean updateAssignments(Statement stat) {
        boolean res = false;
        ArrayList<Object> objects = new ArrayList<Object>(stat.getExprents() == null ? stat.getSequentialObjects() : stat.getExprents());
        for (Object e : objects) {
            Exprent exprent;
            if (e instanceof Statement) {
                res |= SecondaryFunctionsHelper.updateAssignments((Statement)e);
                continue;
            }
            if (!(e instanceof Exprent) || !((exprent = (Exprent)e) instanceof AssignmentExprent)) continue;
            AssignmentExprent assignment = (AssignmentExprent)exprent;
            List<Exprent> params = exprent.getAllExprents();
            Exprent lhs = params.get(0);
            Exprent rhs = params.get(1);
            if (assignment.getCondType() != null || !(lhs instanceof VarExprent) || !(rhs instanceof FunctionExprent)) continue;
            VarExprent lhsVar = (VarExprent)lhs;
            FunctionExprent rhsFunc = (FunctionExprent)rhs;
            List<Exprent> funcParams = rhsFunc.getAllExprents();
            if (!rhsFunc.getFuncType().isArithmeticBinaryOperation() || !(funcParams.get(0) instanceof VarExprent)) continue;
            VarExprent lhsVarFunc = (VarExprent)funcParams.get(0);
            if (lhsVar.getIndex() != lhsVarFunc.getIndex()) continue;
            assignment.setCondType(rhsFunc.getFuncType());
            assignment.setRight(funcParams.get(1));
            res = true;
        }
        return res;
    }

    static {
        funcsnot.put(FunctionExprent.FunctionType.EQ, FunctionExprent.FunctionType.NE);
        funcsnot.put(FunctionExprent.FunctionType.NE, FunctionExprent.FunctionType.EQ);
        funcsnot.put(FunctionExprent.FunctionType.LT, FunctionExprent.FunctionType.GE);
        funcsnot.put(FunctionExprent.FunctionType.GE, FunctionExprent.FunctionType.LT);
        funcsnot.put(FunctionExprent.FunctionType.GT, FunctionExprent.FunctionType.LE);
        funcsnot.put(FunctionExprent.FunctionType.LE, FunctionExprent.FunctionType.GT);
        funcsnot.put(FunctionExprent.FunctionType.BOOLEAN_AND, FunctionExprent.FunctionType.BOOLEAN_OR);
        funcsnot.put(FunctionExprent.FunctionType.BOOLEAN_OR, FunctionExprent.FunctionType.BOOLEAN_AND);
        mapNumComparisons = new HashMap();
        mapNumComparisons.put(FunctionExprent.FunctionType.EQ, new FunctionExprent.FunctionType[]{FunctionExprent.FunctionType.LT, FunctionExprent.FunctionType.EQ, FunctionExprent.FunctionType.GT});
        mapNumComparisons.put(FunctionExprent.FunctionType.NE, new FunctionExprent.FunctionType[]{FunctionExprent.FunctionType.GE, FunctionExprent.FunctionType.NE, FunctionExprent.FunctionType.LE});
        mapNumComparisons.put(FunctionExprent.FunctionType.GT, new FunctionExprent.FunctionType[]{FunctionExprent.FunctionType.GE, FunctionExprent.FunctionType.GT, null});
        mapNumComparisons.put(FunctionExprent.FunctionType.GE, new FunctionExprent.FunctionType[]{null, FunctionExprent.FunctionType.GE, FunctionExprent.FunctionType.GT});
        mapNumComparisons.put(FunctionExprent.FunctionType.LT, new FunctionExprent.FunctionType[]{null, FunctionExprent.FunctionType.LT, FunctionExprent.FunctionType.LE});
        mapNumComparisons.put(FunctionExprent.FunctionType.LE, new FunctionExprent.FunctionType[]{FunctionExprent.FunctionType.LT, FunctionExprent.FunctionType.LE, null});
    }

    public static class IdentifySecondaryOptions {
        private boolean forceTernarySimplification = false;

        public IdentifySecondaryOptions forceTernarySimplification() {
            this.forceTernarySimplification = true;
            return this;
        }
    }
}

