/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.sforms;

import org.jetbrains.java.decompiler.modules.decompiler.ValidationHelper;
import org.jetbrains.java.decompiler.util.collections.SFormsFastMapDirect;

public final class VarMapHolder {
    private SFormsFastMapDirect ifTrue;
    private SFormsFastMapDirect ifFalse;

    private VarMapHolder(SFormsFastMapDirect ifTrue, SFormsFastMapDirect ifFalse) {
        this.ifTrue = ifTrue;
        this.ifFalse = ifFalse;
    }

    public static VarMapHolder ofNormal(SFormsFastMapDirect holder) {
        return new VarMapHolder(holder.getCopy(), null);
    }

    public SFormsFastMapDirect getIfTrue() {
        ValidationHelper.validateTrue(this.ifTrue != null && this.ifTrue != this.ifFalse, "VarMapHolder is in an illegal state");
        return this.ifTrue;
    }

    public SFormsFastMapDirect getIfFalse() {
        ValidationHelper.validateTrue(this.ifTrue != null && this.ifTrue != this.ifFalse, "VarMapHolder is in an illegal state");
        return this.ifFalse == null ? this.ifTrue : this.ifFalse;
    }

    public SFormsFastMapDirect toNormal() {
        SFormsFastMapDirect result = VarMapHolder.mergeMaps(this.ifTrue, this.ifFalse);
        this.ifFalse = null;
        return result;
    }

    public SFormsFastMapDirect getNormal() {
        this.assertIsNormal();
        return this.ifTrue;
    }

    public void assertIsNormal() {
        ValidationHelper.validateTrue(this.isNormal(), "VarMapHolder is not in normal state");
    }

    void setIfTrue(SFormsFastMapDirect ifTrue) {
        if (this.ifTrue != ifTrue && this.ifFalse == null) {
            this.ifFalse = this.ifTrue;
        } else if (this.ifFalse == ifTrue) {
            this.ifFalse = null;
        }
        this.ifTrue = ifTrue;
    }

    void setIfFalse(SFormsFastMapDirect ifFalse) {
        if (this.ifTrue == ifFalse) {
            this.ifTrue = null;
        } else {
            this.ifFalse = ifFalse;
        }
    }

    public void setNormal(SFormsFastMapDirect normal) {
        this.ifFalse = null;
        this.ifTrue = normal;
    }

    public void set(VarMapHolder bVarMaps) {
        this.ifTrue = bVarMaps.ifTrue;
        this.ifFalse = bVarMaps.ifFalse;
    }

    public void mergeIfTrue(SFormsFastMapDirect map2) {
        if (this.ifTrue == map2 || map2 == null || map2.isEmpty()) {
            return;
        }
        this.makeFullyMutable();
        this.ifTrue.union(map2);
    }

    public void mergeIfFalse(SFormsFastMapDirect map2) {
        if (this.ifFalse == map2 || map2 == null || map2.isEmpty()) {
            return;
        }
        this.makeFullyMutable();
        this.ifFalse.union(map2);
    }

    public void mergeNormal(SFormsFastMapDirect map2) {
        this.assertIsNormal();
        if (this.ifTrue == map2 || map2 == null || map2.isEmpty()) {
            return;
        }
        this.ifTrue.union(map2);
    }

    public boolean isNormal() {
        return this.ifFalse == null;
    }

    public void swap() {
        if (this.ifFalse == null) {
            return;
        }
        SFormsFastMapDirect tmp = this.ifTrue;
        this.ifTrue = this.ifFalse;
        this.ifFalse = tmp;
    }

    public void makeFullyMutable() {
        if (this.ifFalse != null) {
            ValidationHelper.validateTrue(this.ifTrue != this.ifFalse, "VarMapHolder is in an illegal state");
            return;
        }
        this.ifFalse = this.ifTrue.getCopy();
    }

    static SFormsFastMapDirect mergeMaps(SFormsFastMapDirect mapTo, SFormsFastMapDirect map2) {
        if (mapTo != map2 && map2 != null && !map2.isEmpty()) {
            mapTo.union(map2);
        }
        return mapTo;
    }

    void removeAllFields() {
        if (this.ifFalse != null) {
            this.ifFalse.removeAllFields();
        }
        this.ifTrue.removeAllFields();
    }
}

