/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.jetbrains.java.decompiler.main.extern.IBytecodeProvider;
import org.jetbrains.java.decompiler.main.extern.IContextSource;
import org.jetbrains.java.decompiler.main.extern.IResultSaver;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.util.DataInputFullStream;
import org.jetbrains.java.decompiler.util.InterpreterUtil;

class SingleFileContextSource
implements IContextSource {
    private final File file;
    private final String qualifiedName;
    private final byte[] contents;

    public SingleFileContextSource(IBytecodeProvider legacyProvider, File singleFile) throws IOException {
        this.file = singleFile;
        if (!singleFile.isFile() && legacyProvider == null) {
            this.contents = null;
            this.qualifiedName = null;
        } else {
            byte[] byArray = this.contents = legacyProvider == null ? InterpreterUtil.getBytes(singleFile) : legacyProvider.getBytecode(singleFile.getAbsolutePath(), null);
            if (this.contents != null && singleFile.getName().endsWith(".class")) {
                try (DataInputFullStream is = new DataInputFullStream(this.contents);){
                    StructClass clazz = StructClass.create(is, false);
                    this.qualifiedName = clazz.qualifiedName;
                }
            } else {
                this.qualifiedName = null;
            }
        }
    }

    @Override
    public String getName() {
        return "file " + this.file;
    }

    @Override
    public IContextSource.Entries getEntries() {
        if (this.contents == null) {
            return IContextSource.Entries.EMPTY;
        }
        if (this.file.getName().endsWith(".class")) {
            return new IContextSource.Entries(List.of(IContextSource.Entry.atBase(this.qualifiedName)), List.of(), List.of());
        }
        return new IContextSource.Entries(List.of(), List.of(), List.of(IContextSource.Entry.atBase(this.file.getName())));
    }

    @Override
    public InputStream getInputStream(String resource) throws IOException {
        return new ByteArrayInputStream(this.contents);
    }

    @Override
    public IContextSource.IOutputSink createOutputSink(final IResultSaver saver) {
        return new IContextSource.IOutputSink(){

            @Override
            public void close() throws IOException {
            }

            @Override
            public void begin() {
            }

            @Override
            public void acceptOther(String path) {
                saver.copyFile(SingleFileContextSource.this.file.getAbsolutePath(), "", path);
            }

            @Override
            public void acceptDirectory(String directory) {
            }

            @Override
            public void acceptClass(String qualifiedName, String fileName, String content, int[] mapping) {
                saver.saveClassFile("", qualifiedName, SingleFileContextSource.this.file.getName().substring(0, SingleFileContextSource.this.file.getName().length() - ".class".length()) + ".java", content, mapping);
            }
        };
    }
}

