/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.analysis.MethodReferenceTreeNode;
import cuchaz.enigma.analysis.ReferenceTreeNode;
import cuchaz.enigma.analysis.index.JarIndex;
import cuchaz.enigma.analysis.index.ReferenceIndex;
import cuchaz.enigma.translation.Translator;
import cuchaz.enigma.translation.representation.entry.FieldEntry;
import cuchaz.enigma.translation.representation.entry.MethodDefEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import cuchaz.enigma.translation.representation.entry.ParentedEntry;
import javax.swing.tree.DefaultMutableTreeNode;

public class FieldReferenceTreeNode
extends DefaultMutableTreeNode
implements ReferenceTreeNode<FieldEntry, MethodDefEntry> {
    private final Translator translator;
    private FieldEntry entry;
    private EntryReference<FieldEntry, MethodDefEntry> reference;

    public FieldReferenceTreeNode(Translator translator, FieldEntry entry) {
        this.translator = translator;
        this.entry = entry;
        this.reference = null;
    }

    private FieldReferenceTreeNode(Translator translator, EntryReference<FieldEntry, MethodDefEntry> reference) {
        this.translator = translator;
        this.entry = (FieldEntry)reference.entry;
        this.reference = reference;
    }

    @Override
    public FieldEntry getEntry() {
        return this.entry;
    }

    @Override
    public EntryReference<FieldEntry, MethodDefEntry> getReference() {
        return this.reference;
    }

    @Override
    public String toString() {
        if (this.reference != null) {
            return String.format("%s", this.translator.translate((MethodDefEntry)this.reference.context));
        }
        return this.translator.translate(this.entry).toString();
    }

    public void load(JarIndex index, boolean recurse) {
        ReferenceIndex referenceIndex = index.getReferenceIndex();
        if (this.reference == null) {
            for (EntryReference<ParentedEntry, MethodDefEntry> entryReference : referenceIndex.getReferencesToField(this.entry)) {
                this.add(new FieldReferenceTreeNode(this.translator, entryReference));
            }
        } else {
            for (EntryReference<ParentedEntry, MethodDefEntry> entryReference : referenceIndex.getReferencesToMethod((MethodEntry)this.reference.context)) {
                this.add(new MethodReferenceTreeNode(this.translator, entryReference));
            }
        }
        if (recurse && this.children != null) {
            for (EntryReference<ParentedEntry, MethodDefEntry> entryReference : this.children) {
                if (entryReference instanceof MethodReferenceTreeNode) {
                    MethodReferenceTreeNode methodNode = (MethodReferenceTreeNode)((Object)entryReference);
                    methodNode.load(index, true, false);
                    continue;
                }
                if (!(entryReference instanceof FieldReferenceTreeNode)) continue;
                FieldReferenceTreeNode fieldNode = (FieldReferenceTreeNode)((Object)entryReference);
                fieldNode.load(index, true);
            }
        }
    }
}

