/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

import cuchaz.enigma.EnigmaProject;
import cuchaz.enigma.analysis.StructureTreeOptions;
import cuchaz.enigma.api.service.NameProposalService;
import cuchaz.enigma.translation.TranslateResult;
import cuchaz.enigma.translation.mapping.EntryRemapper;
import cuchaz.enigma.translation.representation.AccessFlags;
import cuchaz.enigma.translation.representation.TypeDescriptor;
import cuchaz.enigma.translation.representation.entry.ClassDefEntry;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.DefEntry;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.translation.representation.entry.FieldDefEntry;
import cuchaz.enigma.translation.representation.entry.MethodDefEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import cuchaz.enigma.translation.representation.entry.ParentedEntry;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import javax.swing.tree.DefaultMutableTreeNode;

public class StructureTreeNode
extends DefaultMutableTreeNode {
    private final List<NameProposalService> nameProposalServices;
    private final EntryRemapper mapper;
    private final ClassEntry parentEntry;
    private final ParentedEntry entry;

    public StructureTreeNode(EnigmaProject project, ClassEntry parentEntry, ParentedEntry entry) {
        this.nameProposalServices = project.getEnigma().getServices().get(NameProposalService.TYPE);
        this.mapper = project.getMapper();
        this.parentEntry = parentEntry;
        this.entry = entry;
    }

    public ParentedEntry getEntry() {
        return this.entry;
    }

    public void load(EnigmaProject project, StructureTreeOptions options) {
        Stream children = project.getJarIndex().getChildrenByClass().getOrDefault(this.parentEntry, List.of()).stream();
        children = switch (options.obfuscationVisibility()) {
            default -> throw new IncompatibleClassChangeError();
            case StructureTreeOptions.ObfuscationVisibility.ALL -> children;
            case StructureTreeOptions.ObfuscationVisibility.OBFUSCATED -> children.filter(e -> e instanceof ClassEntry || project.isObfuscated((Entry<?>)e) && project.isRenamable((Entry<?>)e)).filter(e -> {
                MethodEntry m;
                return !(e instanceof MethodEntry) || !(m = (MethodEntry)e).isConstructor() || project.isObfuscated((Entry<?>)e.getParent());
            });
            case StructureTreeOptions.ObfuscationVisibility.DEOBFUSCATED -> children.filter(e -> {
                MethodEntry m;
                return e instanceof ClassEntry || !project.isObfuscated((Entry<?>)e) && project.isRenamable((Entry<?>)e) || e instanceof MethodEntry && (m = (MethodEntry)e).isConstructor() && !project.isObfuscated((Entry<?>)e.getParent());
            });
        };
        children = switch (options.documentationVisibility()) {
            default -> throw new IncompatibleClassChangeError();
            case StructureTreeOptions.DocumentationVisibility.ALL -> children;
            case StructureTreeOptions.DocumentationVisibility.DOCUMENTED -> children.filter(e -> e instanceof ClassEntry || project.getMapper().deobfuscate(e).getJavadocs() != null && !project.getMapper().deobfuscate(e).getJavadocs().isBlank());
            case StructureTreeOptions.DocumentationVisibility.NON_DOCUMENTED -> children.filter(e -> e instanceof ClassEntry || project.getMapper().deobfuscate(e).getJavadocs() == null || project.getMapper().deobfuscate(e).getJavadocs().isBlank());
        };
        children = switch (options.sortingOrder()) {
            default -> throw new IncompatibleClassChangeError();
            case StructureTreeOptions.SortingOrder.DEFAULT -> children;
            case StructureTreeOptions.SortingOrder.A_Z -> children.sorted(Comparator.comparing(e -> {
                MethodEntry m;
                return e instanceof MethodEntry && (m = (MethodEntry)e).isConstructor() ? ((Entry)project.getMapper().deobfuscate(e.getParent())).getSimpleName().toLowerCase(Locale.ROOT) : project.getMapper().deobfuscate(e).getSimpleName().toLowerCase();
            }));
            case StructureTreeOptions.SortingOrder.Z_A -> children.sorted(Comparator.comparing(e -> {
                MethodEntry m;
                return e instanceof MethodEntry && (m = (MethodEntry)e).isConstructor() ? ((Entry)project.getMapper().deobfuscate(((ParentedEntry)e).getParent())).getSimpleName().toLowerCase() : project.getMapper().deobfuscate((ParentedEntry)e).getSimpleName().toLowerCase(Locale.ROOT);
            }).reversed());
        };
        for (ParentedEntry child : children.toList()) {
            StructureTreeNode childNode = new StructureTreeNode(project, this.parentEntry, child);
            if (child instanceof ClassEntry) {
                childNode = new StructureTreeNode(project, (ClassEntry)child, child);
                childNode.load(project, options);
            }
            this.add(childNode);
        }
    }

    @Override
    public String toString() {
        TranslateResult<ParentedEntry> translateResult = this.mapper.extendedDeobfuscate(this.entry);
        Object result = translateResult.getValue().getName();
        if (translateResult.isObfuscated() && !this.nameProposalServices.isEmpty()) {
            for (NameProposalService service : this.nameProposalServices) {
                if (!service.proposeName(this.entry, this.mapper).isPresent()) continue;
                result = service.proposeName(this.entry, this.mapper).get();
            }
        }
        if (this.entry instanceof FieldDefEntry) {
            FieldDefEntry field = (FieldDefEntry)translateResult.getValue();
            String returnType = this.parseDesc(field.getDesc());
            result = (String)result + ": " + returnType;
        } else if (this.entry instanceof MethodDefEntry) {
            MethodDefEntry method = (MethodDefEntry)translateResult.getValue();
            String args = this.parseArgs(method.getDesc().getArgumentDescs());
            String returnType = this.parseDesc(method.getDesc().getReturnDesc());
            result = method.isConstructor() ? ((ClassEntry)method.getParent()).getSimpleName() + args : (String)result + args + ": " + returnType;
        }
        return result;
    }

    public String toHtml() {
        ArrayList<String> modifiers = new ArrayList<String>();
        ParentedEntry parentedEntry = this.entry;
        if (parentedEntry instanceof DefEntry) {
            Object p;
            DefEntry defEntry = (DefEntry)((Object)parentedEntry);
            AccessFlags access = defEntry.getAccess();
            boolean isInterfaceMethod = false;
            if (this.entry instanceof MethodEntry && (p = this.entry.getParent()) instanceof ClassDefEntry) {
                ClassDefEntry parent = (ClassDefEntry)p;
                isInterfaceMethod = parent.getAccess().isInterface();
            }
            if (access.isStatic() && !access.isEnum()) {
                modifiers.add("static");
            } else if (isInterfaceMethod && !access.isAbstract()) {
                modifiers.add("default");
            }
            if (access.isAbstract() && !access.isInterface() && !isInterfaceMethod && !access.isEnum()) {
                modifiers.add("abstract");
            } else if (access.isFinal() && !access.isEnum()) {
                modifiers.add("final");
            }
        }
        return "<i>" + String.join((CharSequence)" ", modifiers) + "</i> " + this.toString();
    }

    private String parseArgs(List<TypeDescriptor> args) {
        if (args.size() > 0) {
            Object result = "(";
            for (int i = 0; i < args.size(); ++i) {
                if (i > 0) {
                    result = (String)result + ", ";
                }
                result = (String)result + this.parseDesc(args.get(i));
            }
            return (String)result + ")";
        }
        return "()";
    }

    private String parseDesc(TypeDescriptor desc) {
        if (desc.isVoid()) {
            return "void";
        }
        if (desc.isPrimitive()) {
            return desc.getPrimitive().getKeyword();
        }
        if (desc.isType()) {
            return desc.getTypeEntry().getSimpleName();
        }
        if (desc.isArray()) {
            if (desc.getArrayType().isPrimitive()) {
                return desc.getArrayType().getPrimitive().getKeyword() + "[]";
            }
            if (desc.getArrayType().isType()) {
                return desc.getArrayType().getTypeEntry().getSimpleName() + "[]";
            }
        }
        return null;
    }
}

