/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.config;

import cuchaz.enigma.config.ConfigPaths;
import cuchaz.enigma.config.ConfigSection;
import cuchaz.enigma.config.ConfigSerializer;
import cuchaz.enigma.config.ConfigStructureVisitor;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;

public class ConfigContainer {
    private Path configPath;
    private boolean existsOnDisk;
    private final ConfigSection root = new ConfigSection();

    public ConfigSection data() {
        return this.root;
    }

    public void save() {
        if (this.configPath == null) {
            throw new IllegalStateException("File has no config path set!");
        }
        try {
            Files.createDirectories(this.configPath.getParent(), new FileAttribute[0]);
            Files.write(this.configPath, this.serialize().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            this.existsOnDisk = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveAs(Path path) {
        this.configPath = path;
        this.save();
    }

    public boolean existsOnDisk() {
        return this.existsOnDisk;
    }

    public String serialize() {
        return ConfigSerializer.structureToString(this.root);
    }

    public static ConfigContainer create() {
        return new ConfigContainer();
    }

    public static ConfigContainer getOrCreate(String name) {
        return ConfigContainer.getOrCreate(ConfigPaths.getConfigFilePath(name));
    }

    public static ConfigContainer getOrCreate(Path path) {
        ConfigContainer cc = null;
        try {
            if (Files.exists(path, new LinkOption[0])) {
                String s = String.join((CharSequence)"\n", Files.readAllLines(path));
                cc = ConfigContainer.parse(s);
                cc.existsOnDisk = true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (cc == null) {
            cc = ConfigContainer.create();
        }
        cc.configPath = path;
        return cc;
    }

    public static ConfigContainer parse(String source) {
        final ConfigContainer cc = ConfigContainer.create();
        final LinkedList<ConfigSection> stack = new LinkedList<ConfigSection>();
        stack.push(cc.root);
        ConfigSerializer.parse(source, new ConfigStructureVisitor(){

            @Override
            public void visitKeyValue(String key, String value) {
                ((ConfigSection)stack.peekLast()).setString(key, value);
            }

            @Override
            public void visitSection(String section) {
                stack.add(((ConfigSection)stack.peekLast()).section(section));
            }

            @Override
            public void jumpToRootSection() {
                stack.clear();
                stack.push(cc.root);
            }
        });
        return cc;
    }
}

