/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.config;

import cuchaz.enigma.utils.Os;
import java.nio.file.Path;
import java.nio.file.Paths;

public class ConfigPaths {
    public static Path getConfigFilePath(String name) {
        String fileName = Os.getOs() == Os.LINUX ? String.format("%src", name) : String.format("%s.ini", name);
        return ConfigPaths.getConfigPathRoot().resolve(fileName);
    }

    public static Path getConfigPathRoot() {
        switch (Os.getOs()) {
            case LINUX: {
                String configHome = System.getenv("XDG_CONFIG_HOME");
                if (configHome == null) {
                    return ConfigPaths.getUserHomeUnix().resolve(".config");
                }
                return Paths.get(configHome, new String[0]);
            }
            case MAC: {
                return ConfigPaths.getUserHomeUnix().resolve("Library").resolve("Application Support");
            }
            case WINDOWS: {
                return Paths.get(System.getenv("LOCALAPPDATA"), new String[0]);
            }
        }
        return Paths.get(System.getProperty("user.dir"), new String[0]);
    }

    private static Path getUserHomeUnix() {
        String userHome = System.getenv("HOME");
        if (userHome == null) {
            userHome = System.getProperty("user.dir");
        }
        return Paths.get(userHome, new String[0]);
    }
}

