/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.translation.representation.entry;

import cuchaz.enigma.source.RenamableTokenType;
import cuchaz.enigma.translation.TranslateResult;
import cuchaz.enigma.translation.Translator;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.representation.AccessFlags;
import cuchaz.enigma.translation.representation.MethodDescriptor;
import cuchaz.enigma.translation.representation.Signature;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.DefEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class MethodDefEntry
extends MethodEntry
implements DefEntry<ClassEntry> {
    private final AccessFlags access;
    private final Signature signature;

    public MethodDefEntry(ClassEntry owner, String name, MethodDescriptor descriptor, Signature signature, AccessFlags access) {
        this(owner, name, descriptor, signature, access, null);
    }

    public MethodDefEntry(ClassEntry owner, String name, MethodDescriptor descriptor, Signature signature, AccessFlags access, String docs) {
        super(owner, name, descriptor, docs);
        this.access = Objects.requireNonNull(access, "Method access cannot be null");
        this.signature = Objects.requireNonNull(signature, "Method signature cannot be null");
    }

    public static MethodDefEntry parse(ClassEntry owner, int access, String name, String desc, String signature) {
        return new MethodDefEntry(owner, name, new MethodDescriptor(desc), Signature.createSignature(signature), new AccessFlags(access), null);
    }

    @Override
    public AccessFlags getAccess() {
        return this.access;
    }

    public Signature getSignature() {
        return this.signature;
    }

    @Override
    protected TranslateResult<MethodDefEntry> extendedTranslate(Translator translator, @NotNull EntryMapping mapping) {
        MethodDescriptor translatedDesc = translator.translate(this.descriptor);
        Signature translatedSignature = translator.translate(this.signature);
        String translatedName = mapping.targetName() != null ? mapping.targetName() : this.name;
        AccessFlags translatedAccess = mapping.accessModifier().transform(this.access);
        String docs = mapping.javadoc();
        return TranslateResult.of(mapping.targetName() == null ? RenamableTokenType.OBFUSCATED : RenamableTokenType.DEOBFUSCATED, new MethodDefEntry((ClassEntry)this.parent, translatedName, translatedDesc, translatedSignature, translatedAccess, docs));
    }

    @Override
    public MethodDefEntry withName(String name) {
        return new MethodDefEntry((ClassEntry)this.parent, name, this.descriptor, this.signature, this.access, this.javadocs);
    }

    @Override
    public MethodDefEntry withParent(ClassEntry parent) {
        return new MethodDefEntry(new ClassEntry(parent.getFullName()), this.name, this.descriptor, this.signature, this.access, this.javadocs);
    }
}

