/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.utils;

import com.google.gson.Gson;
import cuchaz.enigma.EnigmaServices;
import cuchaz.enigma.api.service.I18nService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class I18n {
    public static final String DEFAULT_LANGUAGE = "en_us";
    private static final Gson GSON = new Gson();
    private static Map<String, String> defaultTranslations = Map.of();
    private static Map<String, String> translations = Map.of();
    private static final Map<String, String> LANGUAGE_NAMES = new HashMap<String, String>();

    public static void initialize(EnigmaServices services) {
        defaultTranslations = I18n.load(DEFAULT_LANGUAGE, services);
        translations = defaultTranslations;
    }

    private static Map<String, String> load(String language, EnigmaServices services) {
        HashMap<String, String> translations = new HashMap<String, String>();
        for (I18nService i18nService : services.get(I18nService.TYPE)) {
            try {
                InputStream inputStream = i18nService.getTranslationResource(language);
                try {
                    if (inputStream == null) continue;
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                        translations.putAll((Map)GSON.fromJson((Reader)reader, Map.class));
                    }
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return translations;
    }

    public static String translateOrNull(String key) {
        String value = translations.get(key);
        if (value != null) {
            return value;
        }
        return defaultTranslations.get(key);
    }

    public static String translate(String key) {
        String tr = I18n.translateOrNull(key);
        return tr != null ? tr : key;
    }

    public static String translateOrEmpty(String key, Object ... args) {
        String text = I18n.translateOrNull(key);
        if (text != null) {
            return String.format(text, args);
        }
        return "";
    }

    public static String translateFormatted(String key, Object ... args) {
        String text = I18n.translateOrNull(key);
        if (text != null) {
            return String.format(text, args);
        }
        if (args.length == 0) {
            return key;
        }
        return key + Arrays.stream(args).map(Objects::toString).collect(Collectors.joining(", ", "[", "]"));
    }

    public static String getLanguageName(String language) {
        return LANGUAGE_NAMES.get(language);
    }

    public static void setLanguage(String language, EnigmaServices services) {
        translations = I18n.load(language, services);
    }

    public static ArrayList<String> getAvailableLanguages() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            List<String> availableTranslations;
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try (InputStream is = cl.getResourceAsStream("lang/index.txt");){
                availableTranslations = Arrays.asList(new String(is.readAllBytes(), StandardCharsets.UTF_8).split("\n"));
            }
            availableTranslations.forEach(fileName -> {
                list.add((String)fileName);
                I18n.loadLanguageName(fileName);
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return list;
    }

    private static void loadLanguageName(String fileName) {
        try (InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream("lang/" + fileName + ".json");
             BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
            Map map = (Map)GSON.fromJson((Reader)reader, Map.class);
            LANGUAGE_NAMES.put(fileName, map.get("language").toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

