/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.utils;

import java.util.Objects;

public final class TristateChange<T> {
    private static final TristateChange<?> UNCHANGED = new TristateChange<Object>(Type.UNCHANGED, null);
    private static final TristateChange<?> RESET = new TristateChange<Object>(Type.RESET, null);
    private final Type type;
    private final T val;

    public static <T> TristateChange<T> unchanged() {
        return UNCHANGED;
    }

    public static <T> TristateChange<T> reset() {
        return RESET;
    }

    public static <T> TristateChange<T> set(T value) {
        return new TristateChange<T>(Type.SET, value);
    }

    private TristateChange(Type type, T val) {
        this.type = type;
        this.val = val;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isUnchanged() {
        return this.type == Type.UNCHANGED;
    }

    public boolean isReset() {
        return this.type == Type.RESET;
    }

    public boolean isSet() {
        return this.type == Type.SET;
    }

    public T getNewValue() {
        if (this.type != Type.SET) {
            throw new IllegalStateException(String.format("No concrete value in %s", this));
        }
        return this.val;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TristateChange that = (TristateChange)o;
        return this.type == that.type && Objects.equals(this.val, that.val);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.val});
    }

    public String toString() {
        return String.format("TristateChange { type: %s, val: %s }", new Object[]{this.type, this.val});
    }

    public static enum Type {
        UNCHANGED,
        RESET,
        SET;

    }
}

