package org.benf.cfr.reader.bytecode.analysis.structured.statement;

import org.benf.cfr.reader.bytecode.analysis.loc.BytecodeLoc;
import org.benf.cfr.reader.bytecode.analysis.parse.utils.BlockIdentifier;
import org.benf.cfr.reader.bytecode.analysis.structured.StructuredStatement;
import org.benf.cfr.reader.state.TypeUsageCollector;
import org.benf.cfr.reader.util.output.Dumper;

import java.util.Vector;

public class UnstructuredAnonymousBreak extends AbstractUnStructuredStatement {

    private final BlockIdentifier blockEnding;

    public UnstructuredAnonymousBreak(BytecodeLoc loc, BlockIdentifier blockEnding) {
        super(loc);
        this.blockEnding = blockEnding;
    }

    @Override
    public BytecodeLoc getCombinedLoc() {
        return getLoc();
    }

    @Override
    public Dumper dump(Dumper dumper) {
        return dumper.print("** break ").print(blockEnding.getName()).newln();
    }

    @Override
    public void collectTypeUsages(TypeUsageCollector collector) {
    }

    @Override
    public StructuredStatement informBlockHeirachy(Vector<BlockIdentifier> blockIdentifiers) {
        return null;
    }

    StructuredStatement tryExplicitlyPlaceInBlock(BlockIdentifier block) {
        if (block != blockEnding) {
            return this;
        }
        block.addForeignRef();
        return new StructuredBreak(getLoc(), block, false);
    }
}
