/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.classtweaker.validator;

import net.fabricmc.classtweaker.api.ProblemSink;
import net.fabricmc.classtweaker.api.visitor.AccessWidenerVisitor;
import net.fabricmc.classtweaker.api.visitor.ClassTweakerVisitor;
import net.fabricmc.classtweaker.validator.AccessWidenerValidatingVisitor;
import net.fabricmc.tinyremapper.api.TrEnvironment;
import org.jetbrains.annotations.Nullable;

public class ClassTweakerValidatingVisitor
implements ClassTweakerVisitor {
    private final TrEnvironment environment;
    private final ProblemSink sink;
    private int lineNumber;

    public ClassTweakerValidatingVisitor(TrEnvironment environment, ProblemSink sink) {
        this.environment = environment;
        this.sink = sink;
    }

    @Override
    @Nullable
    public AccessWidenerVisitor visitAccessWidener(String owner) {
        return new AccessWidenerValidatingVisitor(this.environment, this.sink, owner, this.lineNumber);
    }

    @Override
    public void visitInjectedInterface(String owner, String iface, boolean transitive) {
        if (this.environment.getClass(owner) == null) {
            this.sink.addProblem(this.lineNumber, String.format("Could not find target class (%s)", owner));
        }
    }

    @Override
    public void visitLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }
}

