/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.biome;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_1959;
import net.minecraft.class_5321;
import net.minecraft.class_6544;
import net.minecraft.class_8197;

public final class NetherBiomeData {
    private static final Set<class_5321<class_1959>> NETHER_BIOMES = new HashSet<class_5321<class_1959>>();
    private static final Map<class_5321<class_1959>, class_6544.class_4762> NETHER_BIOME_NOISE_POINTS = new HashMap<class_5321<class_1959>, class_6544.class_4762>();

    private NetherBiomeData() {
    }

    public static void addNetherBiome(class_5321<class_1959> biome, class_6544.class_4762 spawnNoisePoint) {
        Preconditions.checkArgument((biome != null ? 1 : 0) != 0, (Object)"Biome is null");
        Preconditions.checkArgument((spawnNoisePoint != null ? 1 : 0) != 0, (Object)"MultiNoiseUtil.NoiseValuePoint is null");
        NETHER_BIOME_NOISE_POINTS.put(biome, spawnNoisePoint);
        NetherBiomeData.clearBiomeSourceCache();
    }

    public static boolean canGenerateInNether(class_5321<class_1959> biome) {
        return class_8197.class_5305.field_24723.method_49514().anyMatch(input -> input.equals(biome));
    }

    private static void clearBiomeSourceCache() {
        NETHER_BIOMES.clear();
    }

    public static <T> class_6544.class_6547<T> withModdedBiomeEntries(class_6544.class_6547<T> entries, Function<class_5321<class_1959>, T> biomes) {
        if (NETHER_BIOME_NOISE_POINTS.isEmpty()) {
            return entries;
        }
        ArrayList<Pair> entryList = new ArrayList<Pair>(entries.method_38128());
        for (Map.Entry<class_5321<class_1959>, class_6544.class_4762> entry : NETHER_BIOME_NOISE_POINTS.entrySet()) {
            entryList.add(Pair.of((Object)entry.getValue(), biomes.apply(entry.getKey())));
        }
        return new class_6544.class_6547(Collections.unmodifiableList(entryList));
    }
}

