/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.biome.modification;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.biome.v1.BiomeModificationContext;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.random.Weighted;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.attribute.EnvironmentAttribute;
import net.minecraft.world.attribute.EnvironmentAttributeMap;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.attribute.modifier.AttributeModifier;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.jetbrains.annotations.UnmodifiableView;
import org.jspecify.annotations.Nullable;

public class BiomeModificationContextImpl
implements BiomeModificationContext {
    private final RegistryAccess registries;
    private final Biome biome;
    private final BiomeModificationContext.WeatherContext weather;
    private final BiomeModificationContext.AttributesContext attributes;
    private final BiomeModificationContext.EffectsContext effects;
    private final GenerationSettingsContextImpl generationSettings;
    private final SpawnSettingsContextImpl spawnSettings;

    public BiomeModificationContextImpl(RegistryAccess registries, Biome biome) {
        this.registries = registries;
        this.biome = biome;
        this.weather = new WeatherContextImpl();
        this.attributes = new AttributesContextImpl();
        this.effects = new EffectsContextImpl();
        this.generationSettings = new GenerationSettingsContextImpl();
        this.spawnSettings = new SpawnSettingsContextImpl();
    }

    @Override
    public BiomeModificationContext.WeatherContext getWeather() {
        return this.weather;
    }

    @Override
    public BiomeModificationContext.AttributesContext getAttributes() {
        return this.attributes;
    }

    @Override
    public BiomeModificationContext.EffectsContext getEffects() {
        return this.effects;
    }

    @Override
    public BiomeModificationContext.GenerationSettingsContext getGenerationSettings() {
        return this.generationSettings;
    }

    @Override
    public BiomeModificationContext.SpawnSettingsContext getSpawnSettings() {
        return this.spawnSettings;
    }

    void freeze() {
        this.generationSettings.freeze();
        this.spawnSettings.freeze();
    }

    boolean shouldRebuildFeatures() {
        return this.generationSettings.rebuildFeatures;
    }

    private static <T> Holder.Reference<T> getEntry(Registry<T> registry, ResourceKey<T> key) {
        Holder.Reference entry = registry.get(key).orElse(null);
        if (entry == null) {
            throw new IllegalArgumentException("Couldn't find registry entry for " + String.valueOf(key));
        }
        return entry;
    }

    private class WeatherContextImpl
    implements BiomeModificationContext.WeatherContext {
        private WeatherContextImpl() {
        }

        @Override
        public void setPrecipitation(boolean hasPrecipitation) {
            BiomeModificationContextImpl.this.biome.climateSettings = new Biome.ClimateSettings(hasPrecipitation, BiomeModificationContextImpl.this.biome.climateSettings.temperature(), BiomeModificationContextImpl.this.biome.climateSettings.temperatureModifier(), BiomeModificationContextImpl.this.biome.climateSettings.downfall());
        }

        @Override
        public void setTemperature(float temperature) {
            BiomeModificationContextImpl.this.biome.climateSettings = new Biome.ClimateSettings(BiomeModificationContextImpl.this.biome.climateSettings.hasPrecipitation(), temperature, BiomeModificationContextImpl.this.biome.climateSettings.temperatureModifier(), BiomeModificationContextImpl.this.biome.climateSettings.downfall());
        }

        @Override
        public void setTemperatureModifier(Biome.TemperatureModifier temperatureModifier) {
            BiomeModificationContextImpl.this.biome.climateSettings = new Biome.ClimateSettings(BiomeModificationContextImpl.this.biome.climateSettings.hasPrecipitation(), BiomeModificationContextImpl.this.biome.climateSettings.temperature(), Objects.requireNonNull(temperatureModifier), BiomeModificationContextImpl.this.biome.climateSettings.downfall());
        }

        @Override
        public void setDownfall(float downfall) {
            BiomeModificationContextImpl.this.biome.climateSettings = new Biome.ClimateSettings(BiomeModificationContextImpl.this.biome.climateSettings.hasPrecipitation(), BiomeModificationContextImpl.this.biome.climateSettings.temperature(), BiomeModificationContextImpl.this.biome.climateSettings.temperatureModifier(), downfall);
        }
    }

    private class AttributesContextImpl
    implements BiomeModificationContext.AttributesContext {
        private AttributesContextImpl() {
        }

        @Override
        public void addAll(EnvironmentAttributeMap map) {
            EnvironmentAttributeMap.Builder attributes = EnvironmentAttributeMap.builder().putAll(BiomeModificationContextImpl.this.biome.getAttributes());
            attributes.putAll(map);
            BiomeModificationContextImpl.this.biome.attributes = attributes.build();
        }

        @Override
        public <T> void set(EnvironmentAttribute<T> key, T value) {
            EnvironmentAttributeMap.Builder attributes = EnvironmentAttributeMap.builder().putAll(BiomeModificationContextImpl.this.biome.getAttributes());
            attributes.set(key, value);
            BiomeModificationContextImpl.this.biome.attributes = attributes.build();
        }

        @Override
        public <T, M> void setModifier(EnvironmentAttribute<T> key, AttributeModifier<T, M> modifier, M value) {
            EnvironmentAttributeMap.Builder attributes = EnvironmentAttributeMap.builder().putAll(BiomeModificationContextImpl.this.biome.getAttributes());
            attributes.modify(key, modifier, value);
            BiomeModificationContextImpl.this.biome.attributes = attributes.build();
        }
    }

    private class EffectsContextImpl
    implements BiomeModificationContext.EffectsContext {
        private final BiomeSpecialEffects effects;

        private EffectsContextImpl() {
            this.effects = BiomeModificationContextImpl.this.biome.getSpecialEffects();
        }

        @Override
        public void setFogColor(int color) {
            BiomeModificationContextImpl.this.attributes.set(EnvironmentAttributes.FOG_COLOR, color);
        }

        @Override
        public void setWaterColor(int color) {
            this.effects.waterColor = color;
        }

        @Override
        public void setWaterFogColor(int color) {
            BiomeModificationContextImpl.this.attributes.set(EnvironmentAttributes.WATER_FOG_COLOR, color);
        }

        @Override
        public void setSkyColor(int color) {
            BiomeModificationContextImpl.this.attributes.set(EnvironmentAttributes.SKY_COLOR, color);
        }

        @Override
        public void setFoliageColor(Optional<Integer> color) {
            this.effects.foliageColorOverride = Objects.requireNonNull(color);
        }

        @Override
        public void setDryFoliageColor(Optional<Integer> color) {
            this.effects.dryFoliageColorOverride = Objects.requireNonNull(color);
        }

        @Override
        public void setGrassColor(Optional<Integer> color) {
            this.effects.grassColorOverride = Objects.requireNonNull(color);
        }

        @Override
        public void setGrassColorModifier(BiomeSpecialEffects.GrassColorModifier colorModifier) {
            this.effects.grassColorModifier = Objects.requireNonNull(colorModifier);
        }

        @Override
        public void setMusicVolume(float volume) {
            BiomeModificationContextImpl.this.attributes.set(EnvironmentAttributes.MUSIC_VOLUME, Float.valueOf(volume));
        }
    }

    private class GenerationSettingsContextImpl
    implements BiomeModificationContext.GenerationSettingsContext {
        private final Registry<ConfiguredWorldCarver<?>> carvers;
        private final Registry<PlacedFeature> features;
        private final BiomeGenerationSettings generationSettings;
        boolean rebuildFeatures;

        GenerationSettingsContextImpl() {
            this.carvers = BiomeModificationContextImpl.this.registries.lookupOrThrow(Registries.CONFIGURED_CARVER);
            this.features = BiomeModificationContextImpl.this.registries.lookupOrThrow(Registries.PLACED_FEATURE);
            this.generationSettings = BiomeModificationContextImpl.this.biome.getGenerationSettings();
            this.unfreezeFeatures();
            this.rebuildFeatures = false;
        }

        private void unfreezeFeatures() {
            this.generationSettings.features = new ArrayList(this.generationSettings.features);
        }

        public void freeze() {
            this.freezeFeatures();
            if (this.rebuildFeatures) {
                this.rebuildFlowerFeatures();
            }
        }

        private void freezeFeatures() {
            this.generationSettings.features = ImmutableList.copyOf((Collection)this.generationSettings.features);
            this.generationSettings.featureSet = Suppliers.memoize(() -> this.generationSettings.features.stream().flatMap(HolderSet::stream).map(Holder::value).collect(Collectors.toSet()));
        }

        private void rebuildFlowerFeatures() {
            this.generationSettings.flowerFeatures = Suppliers.memoize(() -> (List)this.generationSettings.features.stream().flatMap(HolderSet::stream).map(Holder::value).flatMap(PlacedFeature::getFeatures).filter(configuredFeature -> configuredFeature.feature() == Feature.FLOWER).collect(ImmutableList.toImmutableList()));
        }

        @Override
        public boolean removeFeature(GenerationStep.Decoration step, ResourceKey<PlacedFeature> placedFeatureKey) {
            List featureSteps;
            PlacedFeature placedFeature = (PlacedFeature)BiomeModificationContextImpl.getEntry(this.features, placedFeatureKey).value();
            int stepIndex = step.ordinal();
            if (stepIndex >= (featureSteps = this.generationSettings.features).size()) {
                return false;
            }
            HolderSet featuresInStep = (HolderSet)featureSteps.get(stepIndex);
            ArrayList features = new ArrayList(featuresInStep.stream().toList());
            if (features.removeIf(feature -> feature.value() == placedFeature)) {
                featureSteps.set(stepIndex, HolderSet.direct(features));
                this.rebuildFeatures = true;
                return true;
            }
            return false;
        }

        @Override
        public void addFeature(GenerationStep.Decoration step, ResourceKey<PlacedFeature> entry) {
            List featureSteps = this.generationSettings.features;
            int index = step.ordinal();
            while (index >= featureSteps.size()) {
                featureSteps.add(HolderSet.direct(Collections.emptyList()));
            }
            Holder.Reference<PlacedFeature> feature = BiomeModificationContextImpl.getEntry(this.features, entry);
            if (((HolderSet)featureSteps.get(index)).contains(feature)) {
                return;
            }
            featureSteps.set(index, this.plus((HolderSet)((HolderSet)featureSteps.get(index)), (Holder)feature));
            this.rebuildFeatures = true;
        }

        @Override
        public void addCarver(ResourceKey<ConfiguredWorldCarver<?>> entry) {
            this.generationSettings.carvers = this.plus((HolderSet)this.generationSettings.carvers, (Holder)BiomeModificationContextImpl.getEntry(this.carvers, entry));
        }

        @Override
        public boolean removeCarver(ResourceKey<ConfiguredWorldCarver<?>> configuredCarverKey) {
            ConfiguredWorldCarver carver = (ConfiguredWorldCarver)BiomeModificationContextImpl.getEntry(this.carvers, configuredCarverKey).value();
            ArrayList genCarvers = new ArrayList(this.generationSettings.carvers.stream().toList());
            if (genCarvers.removeIf(entry -> entry.value() == carver)) {
                this.generationSettings.carvers = HolderSet.direct(genCarvers);
                return true;
            }
            return false;
        }

        private <T> HolderSet<T> plus(@Nullable HolderSet<T> values, Holder<T> entry) {
            if (values == null) {
                return HolderSet.direct((Holder[])new Holder[]{entry});
            }
            ArrayList list = new ArrayList(values.stream().toList());
            list.add(entry);
            return HolderSet.direct(list);
        }
    }

    private class SpawnSettingsContextImpl
    implements BiomeModificationContext.SpawnSettingsContext {
        private final MobSpawnSettings spawnSettings;
        private final EnumMap<MobCategory, List<Weighted<MobSpawnSettings.SpawnerData>>> fabricSpawners;

        SpawnSettingsContextImpl() {
            this.spawnSettings = BiomeModificationContextImpl.this.biome.getMobSettings();
            this.fabricSpawners = new EnumMap(MobCategory.class);
            this.unfreezeSpawners();
            this.unfreezeSpawnCost();
        }

        private void unfreezeSpawners() {
            this.fabricSpawners.clear();
            for (MobCategory spawnGroup : MobCategory.values()) {
                WeightedList entries = (WeightedList)this.spawnSettings.spawners.get(spawnGroup);
                if (entries != null) {
                    this.fabricSpawners.put(spawnGroup, new ArrayList(entries.unwrap()));
                    continue;
                }
                this.fabricSpawners.put(spawnGroup, new ArrayList());
            }
        }

        private void unfreezeSpawnCost() {
            this.spawnSettings.mobSpawnCosts = new HashMap(this.spawnSettings.mobSpawnCosts);
        }

        public void freeze() {
            this.freezeSpawners();
            this.freezeSpawnCosts();
        }

        private void freezeSpawners() {
            HashMap<MobCategory, WeightedList> spawners = new HashMap<MobCategory, WeightedList>(this.spawnSettings.spawners);
            for (Map.Entry<MobCategory, List<Weighted<MobSpawnSettings.SpawnerData>>> entry : this.fabricSpawners.entrySet()) {
                if (entry.getValue().isEmpty()) {
                    spawners.put(entry.getKey(), WeightedList.of());
                    continue;
                }
                spawners.put(entry.getKey(), WeightedList.of(entry.getValue()));
            }
            this.spawnSettings.spawners = ImmutableMap.copyOf(spawners);
        }

        private void freezeSpawnCosts() {
            this.spawnSettings.mobSpawnCosts = ImmutableMap.copyOf((Map)this.spawnSettings.mobSpawnCosts);
        }

        @Override
        public void setCreatureSpawnProbability(float probability) {
            this.spawnSettings.creatureGenerationProbability = probability;
        }

        @Override
        public @UnmodifiableView List<Weighted<// Could not load outer class - annotation placement on inner may be incorrect
        MobSpawnSettings.SpawnerData>> getSpawnEntries(MobCategory spawnGroup) {
            Objects.requireNonNull(spawnGroup);
            return Collections.unmodifiableList(this.fabricSpawners.get(spawnGroup));
        }

        @Override
        public void addSpawn(MobCategory spawnGroup, MobSpawnSettings.SpawnerData spawnEntry, int weight) {
            Objects.requireNonNull(spawnGroup);
            Objects.requireNonNull(spawnEntry);
            this.fabricSpawners.get(spawnGroup).add((Weighted<MobSpawnSettings.SpawnerData>)new Weighted((Object)spawnEntry, weight));
        }

        @Override
        public boolean removeSpawns(BiPredicate<MobCategory, MobSpawnSettings.SpawnerData> predicate) {
            boolean anyRemoved = false;
            for (MobCategory group : MobCategory.values()) {
                if (!this.fabricSpawners.get(group).removeIf(entry -> predicate.test(group, (MobSpawnSettings.SpawnerData)entry.value()))) continue;
                anyRemoved = true;
            }
            return anyRemoved;
        }

        @Override
        public void setSpawnCost(EntityType<?> entityType, double mass, double gravityLimit) {
            Objects.requireNonNull(entityType);
            this.spawnSettings.mobSpawnCosts.put(entityType, new MobSpawnSettings.MobSpawnCost(gravityLimit, mass));
        }

        @Override
        public void clearSpawnCost(EntityType<?> entityType) {
            this.spawnSettings.mobSpawnCosts.remove(entityType);
        }
    }
}

