/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.gametest.context;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.gametest.v1.context.ClientGameTestContext;
import net.fabricmc.fabric.api.client.gametest.v1.screenshot.TestScreenshotComparisonAlgorithm;
import net.fabricmc.fabric.api.client.gametest.v1.screenshot.TestScreenshotComparisonOptions;
import net.fabricmc.fabric.api.client.gametest.v1.screenshot.TestScreenshotOptions;
import net.fabricmc.fabric.api.client.gametest.v1.world.TestWorldBuilder;
import net.fabricmc.fabric.impl.client.gametest.TestInputImpl;
import net.fabricmc.fabric.impl.client.gametest.TestSystemProperties;
import net.fabricmc.fabric.impl.client.gametest.screenshot.TestScreenshotCommonOptionsImpl;
import net.fabricmc.fabric.impl.client.gametest.screenshot.TestScreenshotComparisonAlgorithms;
import net.fabricmc.fabric.impl.client.gametest.screenshot.TestScreenshotComparisonOptionsImpl;
import net.fabricmc.fabric.impl.client.gametest.screenshot.TestScreenshotOptionsImpl;
import net.fabricmc.fabric.impl.client.gametest.threading.ThreadingImpl;
import net.fabricmc.fabric.impl.client.gametest.world.TestWorldBuilderImpl;
import net.fabricmc.fabric.mixin.client.gametest.gui.CycleButtonAccessor;
import net.fabricmc.fabric.mixin.client.gametest.gui.ScreenAccessor;
import net.fabricmc.fabric.mixin.client.gametest.lifecycle.OptionsAccessor;
import net.fabricmc.fabric.mixin.client.gametest.screenshot.DeltaTrackerDefaultValueAccessor;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1011;
import net.minecraft.class_1157;
import net.minecraft.class_11907;
import net.minecraft.class_11910;
import net.minecraft.class_2561;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_318;
import net.minecraft.class_339;
import net.minecraft.class_3419;
import net.minecraft.class_4063;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_4264;
import net.minecraft.class_437;
import net.minecraft.class_5676;
import net.minecraft.class_7172;
import net.minecraft.class_768;
import net.minecraft.class_8021;
import net.minecraft.class_8144;
import net.minecraft.class_9779;
import org.apache.commons.lang3.function.FailableConsumer;
import org.apache.commons.lang3.function.FailableFunction;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableObject;
import org.joml.Vector2i;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public final class ClientGameTestContextImpl
implements ClientGameTestContext {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"fabric-client-gametest-api-v1");
    private final TestInputImpl input = new TestInputImpl(this);
    private static int screenshotCounter = 0;
    private static final Map<String, Object> DEFAULT_GAME_OPTIONS = new HashMap<String, Object>();

    public static void initGameOptions(class_315 options) {
        options.field_1875 = class_1157.field_5653;
        options.method_42528().method_41748((Object)class_4063.field_18162);
        options.field_41785 = false;
        options.method_42503().method_41748((Object)5);
        options.method_45578(class_3419.field_15253).method_41748((Object)0.0);
        options.method_76247().method_41748((Object)0);
        options.method_76253().method_41748((Object)0.0);
        ((OptionsAccessor)options).invokeAccept(new class_315.class_5823(){

            public int method_33680(String key, int current) {
                DEFAULT_GAME_OPTIONS.put(key, current);
                return current;
            }

            public boolean method_33684(String key, boolean current) {
                DEFAULT_GAME_OPTIONS.put(key, current);
                return current;
            }

            public String method_33683(String key, String current) {
                DEFAULT_GAME_OPTIONS.put(key, current);
                return current;
            }

            public float method_33679(String key, float current) {
                DEFAULT_GAME_OPTIONS.put(key, Float.valueOf(current));
                return current;
            }

            public <T> T method_33681(String key, T current, Function<String, T> decoder, Function<T, String> encoder) {
                DEFAULT_GAME_OPTIONS.put(key, current);
                return current;
            }

            public <T> void method_42570(String key, class_7172<T> option) {
                DEFAULT_GAME_OPTIONS.put(key, option.method_41753());
            }
        });
    }

    @Override
    public void waitTick() {
        ThreadingImpl.checkOnGametestThread("waitTick");
        ThreadingImpl.runTick();
    }

    @Override
    public void waitTicks(int ticks) {
        ThreadingImpl.checkOnGametestThread("waitTicks");
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"ticks cannot be negative");
        for (int i = 0; i < ticks; ++i) {
            ThreadingImpl.runTick();
        }
    }

    @Override
    public int waitFor(Predicate<class_310> predicate) {
        ThreadingImpl.checkOnGametestThread("waitFor");
        Preconditions.checkNotNull(predicate, (Object)"predicate");
        return this.waitFor(predicate, 200);
    }

    @Override
    public int waitFor(Predicate<class_310> predicate, int timeout) {
        ThreadingImpl.checkOnGametestThread("waitFor");
        Preconditions.checkNotNull(predicate, (Object)"predicate");
        if (timeout == -1) {
            int ticksWaited = 0;
            while (!((Boolean)this.computeOnClient(predicate::test)).booleanValue()) {
                ++ticksWaited;
                ThreadingImpl.runTick();
            }
            return ticksWaited;
        }
        Preconditions.checkArgument((timeout > 0 ? 1 : 0) != 0, (Object)"timeout must be positive");
        for (int i = 0; i < timeout; ++i) {
            if (((Boolean)this.computeOnClient(predicate::test)).booleanValue()) {
                return i;
            }
            ThreadingImpl.runTick();
        }
        if (!((Boolean)this.computeOnClient(predicate::test)).booleanValue()) {
            throw new AssertionError((Object)"Timed out waiting for predicate");
        }
        return timeout;
    }

    @Override
    public int waitForScreen(@Nullable Class<? extends class_437> screenClass) {
        ThreadingImpl.checkOnGametestThread("waitForScreen");
        if (screenClass == null) {
            return this.waitFor(client -> client.field_1755 == null);
        }
        return this.waitFor(client -> screenClass.isInstance(client.field_1755));
    }

    @Override
    public void setScreen(Supplier<@Nullable class_437> screen) {
        ThreadingImpl.checkOnGametestThread("setScreen");
        this.runOnClient(client -> client.method_1507((class_437)screen.get()));
    }

    @Override
    public void clickScreenButton(String translationKey) {
        ThreadingImpl.checkOnGametestThread("clickScreenButton");
        Preconditions.checkNotNull((Object)translationKey, (Object)"translationKey");
        this.runOnClient(client -> {
            if (!ClientGameTestContextImpl.tryClickScreenButtonImpl(client.field_1755, translationKey)) {
                throw new AssertionError((Object)"Could not find button '%s' in screen '%s'".formatted(translationKey, class_8144.method_49077((Object)client.field_1755, screen -> screen.getClass().getName())));
            }
        });
    }

    @Override
    public boolean tryClickScreenButton(String translationKey) {
        ThreadingImpl.checkOnGametestThread("tryClickScreenButton");
        Preconditions.checkNotNull((Object)translationKey, (Object)"translationKey");
        return (Boolean)this.computeOnClient(client -> ClientGameTestContextImpl.tryClickScreenButtonImpl(client.field_1755, translationKey));
    }

    private static boolean tryClickScreenButtonImpl(@Nullable class_437 screen, String translationKey) {
        if (screen == null) {
            return false;
        }
        String buttonText = class_2561.method_43471((String)translationKey).getString();
        ScreenAccessor screenAccessor = (ScreenAccessor)screen;
        for (class_4068 drawable : screenAccessor.getDrawables()) {
            class_4264 pressableWidget;
            if (drawable instanceof class_4264 && ClientGameTestContextImpl.pressMatchingButton((class_339)(pressableWidget = (class_4264)drawable), buttonText)) {
                return true;
            }
            if (!(drawable instanceof class_8021)) continue;
            class_8021 widget = (class_8021)drawable;
            MutableBoolean found = new MutableBoolean(false);
            widget.method_48206(clickableWidget -> {
                if (!found.booleanValue()) {
                    found.setValue(ClientGameTestContextImpl.pressMatchingButton(clickableWidget, buttonText));
                }
            });
            if (!found.booleanValue()) continue;
            return true;
        }
        return false;
    }

    private static boolean pressMatchingButton(class_339 widget, String text) {
        CycleButtonAccessor accessor;
        class_4185 buttonWidget;
        class_11910 clickEvent = new class_11910(-1, 0);
        if (widget instanceof class_4185 && text.equals((buttonWidget = (class_4185)widget).method_25369().getString())) {
            buttonWidget.method_25306((class_11907)clickEvent);
            return true;
        }
        if (widget instanceof class_5676 && text.equals((accessor = (CycleButtonAccessor)(buttonWidget = (class_5676)widget)).getOptionText().getString())) {
            buttonWidget.method_25306((class_11907)clickEvent);
            return true;
        }
        return false;
    }

    @Override
    public Path takeScreenshot(TestScreenshotOptions options) {
        ThreadingImpl.checkOnGametestThread("takeScreenshot");
        Preconditions.checkNotNull((Object)options, (Object)"options");
        TestScreenshotOptionsImpl optionsImpl = (TestScreenshotOptionsImpl)options;
        return this.doTakeScreenshot(optionsImpl, screenshot -> ClientGameTestContextImpl.saveScreenshot(screenshot, optionsImpl.name, optionsImpl));
    }

    @Override
    public void assertScreenshotEquals(TestScreenshotComparisonOptions options) {
        ThreadingImpl.checkOnGametestThread("assertScreenshotEquals");
        Preconditions.checkNotNull((Object)options, (Object)"options");
        this.doAssertScreenshotContains(options, (haystackImage, needleImage) -> haystackImage.width() == needleImage.width() && haystackImage.height() == needleImage.height());
    }

    @Override
    public Vector2i assertScreenshotContains(TestScreenshotComparisonOptions options) {
        ThreadingImpl.checkOnGametestThread("assertScreenshotContains");
        Preconditions.checkNotNull((Object)options, (Object)"options");
        return this.doAssertScreenshotContains(options, (haystackImage, needleImage) -> true);
    }

    private Vector2i doAssertScreenshotContains(TestScreenshotComparisonOptions options, BiPredicate<TestScreenshotComparisonAlgorithm.RawImage<?>, TestScreenshotComparisonAlgorithm.RawImage<?>> preCheck) {
        TestScreenshotComparisonOptionsImpl optionsImpl = (TestScreenshotComparisonOptionsImpl)options;
        return this.doTakeScreenshot(optionsImpl, screenshot -> {
            class_768 region = optionsImpl.region == null ? new class_768(0, 0, screenshot.method_4307(), screenshot.method_4323()) : optionsImpl.region;
            Preconditions.checkState((region.method_3321() + region.method_3319() <= screenshot.method_4307() && region.method_3322() + region.method_3320() <= screenshot.method_4323() ? 1 : 0) != 0, (Object)"Screenshot comparison region extends outside the screenshot");
            try (class_1011 subScreenshot = new class_1011(region.method_3319(), region.method_3320(), false);){
                Vector2i result;
                screenshot.method_4300(region.method_3321(), region.method_3322(), region.method_3319(), region.method_3320(), subScreenshot);
                if (optionsImpl.savedFileName != null) {
                    ClientGameTestContextImpl.saveScreenshot(subScreenshot, optionsImpl.savedFileName, optionsImpl);
                }
                if (optionsImpl.grayscale) {
                    templateImage = optionsImpl.getGrayscaleTemplateImage();
                    if (templateImage == null) {
                        ClientGameTestContextImpl.onTemplateImageDoesntExist(subScreenshot, optionsImpl);
                        Vector2i vector2i = new Vector2i(region.method_3321(), region.method_3322());
                        return vector2i;
                    }
                    TestScreenshotComparisonAlgorithm.RawImage<byte[]> haystackImage = TestScreenshotComparisonAlgorithms.RawImageImpl.fromGrayscaleNativeImage(subScreenshot);
                    result = preCheck.test(haystackImage, templateImage) ? optionsImpl.algorithm.findGrayscale(haystackImage, templateImage) : null;
                } else {
                    templateImage = optionsImpl.getColorTemplateImage();
                    if (templateImage == null) {
                        ClientGameTestContextImpl.onTemplateImageDoesntExist(subScreenshot, optionsImpl);
                        Vector2i haystackImage = new Vector2i(region.method_3321(), region.method_3322());
                        return haystackImage;
                    }
                    TestScreenshotComparisonAlgorithm.RawImage<int[]> haystackImage = TestScreenshotComparisonAlgorithms.RawImageImpl.fromColorNativeImage(subScreenshot);
                    result = preCheck.test(haystackImage, templateImage) ? optionsImpl.algorithm.findColor(haystackImage, templateImage) : null;
                }
                if (result == null) {
                    throw new AssertionError((Object)("Screenshot does not contain template" + optionsImpl.getTemplateImagePath().map(arg_0 -> ClientGameTestContextImpl.lambda$doAssertScreenshotContains$10(" '%s'", arg_0)).orElse("")));
                }
                Vector2i vector2i = result.add(region.method_3321(), region.method_3322());
                return vector2i;
            }
        });
    }

    private <T> T doTakeScreenshot(TestScreenshotCommonOptionsImpl<?> options, Function<class_1011, T> screenshotConsumer) {
        ThreadingImpl.checkOnGametestThread("doTakeScreenshot");
        Vector2i prevSize = (Vector2i)this.computeOnClient(client -> {
            int prevWidth = client.method_22683().method_4489();
            int prevHeight = client.method_22683().method_4506();
            if (options.size != null) {
                client.method_22683().method_35642(options.size.x);
                client.method_22683().method_35643(options.size.y);
                client.method_1522().method_1234(options.size.x, options.size.y);
            }
            return new Vector2i(prevWidth, prevHeight);
        });
        try {
            CompletableFuture future = (CompletableFuture)this.computeOnClient(client -> {
                client.field_1773.method_3192((class_9779)DeltaTrackerDefaultValueAccessor.create(options.tickDelta), true);
                CompletableFuture resultFuture = new CompletableFuture();
                class_318.method_1663((class_276)client.method_1522(), screenshot -> {
                    try {
                        resultFuture.complete(screenshotConsumer.apply((class_1011)screenshot));
                    }
                    catch (Throwable e) {
                        resultFuture.completeExceptionally(e);
                    }
                });
                return resultFuture;
            });
            while (!future.isDone()) {
                this.waitTick();
            }
            Object t = future.get();
            return t;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (options.size != null) {
                this.computeOnClient(client -> {
                    client.method_22683().method_35642(prevSize.x);
                    client.method_22683().method_35643(prevSize.y);
                    client.method_1522().method_1234(prevSize.x, prevSize.y);
                    return null;
                });
            }
        }
    }

    private static Path saveScreenshot(class_1011 screenshot, String fileName, TestScreenshotCommonOptionsImpl<?> options) {
        Path destinationDir = Objects.requireNonNullElseGet(options.destinationDir, () -> FabricLoader.getInstance().getGameDir().resolve("screenshots"));
        try {
            Files.createDirectories(destinationDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new AssertionError("Failed to create screenshots directory", e);
        }
        String counterPrefix = options.counterPrefix ? String.format(Locale.ROOT, "%04d_", screenshotCounter++) : "";
        Path screenshotFile = destinationDir.resolve(counterPrefix + fileName + ".png");
        try {
            screenshot.method_4314(screenshotFile);
        }
        catch (IOException e) {
            throw new AssertionError("Failed to write screenshot file", e);
        }
        return screenshotFile;
    }

    private static void onTemplateImageDoesntExist(class_1011 subScreenshot, TestScreenshotComparisonOptionsImpl options) {
        Path savePath;
        if (TestSystemProperties.TEST_MOD_RESOURCES_PATH != null) {
            savePath = Path.of(TestSystemProperties.TEST_MOD_RESOURCES_PATH, new String[0]).resolve("templates").resolve(options.getTemplateImagePathOrThrow() + ".png");
            try {
                Files.createDirectories(savePath.getParent(), new FileAttribute[0]);
                subScreenshot.method_4314(savePath);
            }
            catch (IOException e) {
                throw new AssertionError("Failed to write screenshot file", e);
            }
        } else {
            LOGGER.error("The template image does not exist. Set the fabric.client.gametest.testModResourcesPath system property to your test mod resources file path to automatically save it");
            throw new AssertionError((Object)"Template image does not exist");
        }
        LOGGER.info("Written absent screenshot template to {}", (Object)savePath);
    }

    @Override
    public TestInputImpl getInput() {
        return this.input;
    }

    @Override
    public TestWorldBuilder worldBuilder() {
        return new TestWorldBuilderImpl(this);
    }

    @Override
    public void restoreDefaultGameOptions() {
        ThreadingImpl.checkOnGametestThread("restoreDefaultGameOptions");
        this.runOnClient(client -> ((OptionsAccessor)class_310.method_1551().field_1690).invokeAccept(new class_315.class_5823(this){

            public int method_33680(String key, int current) {
                return (Integer)DEFAULT_GAME_OPTIONS.get(key);
            }

            public boolean method_33684(String key, boolean current) {
                return (Boolean)DEFAULT_GAME_OPTIONS.get(key);
            }

            public String method_33683(String key, String current) {
                return (String)DEFAULT_GAME_OPTIONS.get(key);
            }

            public float method_33679(String key, float current) {
                return ((Float)DEFAULT_GAME_OPTIONS.get(key)).floatValue();
            }

            public <T> T method_33681(String key, T current, Function<String, T> decoder, Function<T, String> encoder) {
                return (T)DEFAULT_GAME_OPTIONS.get(key);
            }

            public <T> void method_42570(String key, class_7172<T> option) {
                option.method_41748(DEFAULT_GAME_OPTIONS.get(key));
            }
        }));
    }

    @Override
    public <E extends Throwable> void runOnClient(FailableConsumer<class_310, E> action) throws E {
        ThreadingImpl.checkOnGametestThread("runOnClient");
        Preconditions.checkNotNull(action, (Object)"action");
        ThreadingImpl.runOnClient(() -> action.accept((Object)class_310.method_1551()));
    }

    @Override
    public <T, E extends Throwable> T computeOnClient(FailableFunction<class_310, T, E> function) throws E {
        ThreadingImpl.checkOnGametestThread("computeOnClient");
        Preconditions.checkNotNull(function, (Object)"function");
        MutableObject result = new MutableObject();
        ThreadingImpl.runOnClient(() -> result.setValue(function.apply((Object)class_310.method_1551())));
        return (T)result.getValue();
    }

    private static /* synthetic */ String lambda$doAssertScreenshotContains$10(String rec$, Object xva$0) {
        return " '%s'".formatted(xva$0);
    }
}

