/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.content.registry;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import net.fabricmc.fabric.api.event.lifecycle.v1.CommonLifecycleEvents;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.fabricmc.fabric.impl.content.registry.FireBlockHooks;
import net.minecraft.class_2248;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class FlammableBlockRegistryImpl
implements FlammableBlockRegistry {
    private static final FlammableBlockRegistry.Entry REMOVED = new FlammableBlockRegistry.Entry(0, 0);
    private static final Map<class_2248, FlammableBlockRegistryImpl> REGISTRIES = new HashMap<class_2248, FlammableBlockRegistryImpl>();
    private final Map<class_2248, FlammableBlockRegistry.Entry> registeredEntriesBlock = new HashMap<class_2248, FlammableBlockRegistry.Entry>();
    private final Map<class_6862<class_2248>, FlammableBlockRegistry.Entry> registeredEntriesTag = new HashMap<class_6862<class_2248>, FlammableBlockRegistry.Entry>();
    private volatile Map<class_2248, FlammableBlockRegistry.Entry> computedEntries = null;
    private final class_2248 key;

    private FlammableBlockRegistryImpl(class_2248 key) {
        this.key = key;
        CommonLifecycleEvents.TAGS_LOADED.register((registries, client) -> {
            this.computedEntries = null;
        });
    }

    private Map<class_2248, FlammableBlockRegistry.Entry> getEntryMap() {
        Map<class_2248, FlammableBlockRegistry.Entry> ret = this.computedEntries;
        if (ret == null) {
            ret = new IdentityHashMap<class_2248, FlammableBlockRegistry.Entry>();
            for (class_6862<class_2248> tag : this.registeredEntriesTag.keySet()) {
                FlammableBlockRegistry.Entry entry = this.registeredEntriesTag.get(tag);
                for (class_6880 block : class_7923.field_41175.method_40286(tag)) {
                    ret.put((class_2248)block.comp_349(), entry);
                }
            }
            ret.putAll(this.registeredEntriesBlock);
            this.computedEntries = ret;
        }
        return ret;
    }

    @Override
    public FlammableBlockRegistry.Entry get(class_2248 block) {
        FlammableBlockRegistry.Entry entry = this.getEntryMap().get(block);
        if (entry != null) {
            return entry;
        }
        return ((FireBlockHooks)this.key).fabric_getVanillaEntry(block.method_9564());
    }

    public FlammableBlockRegistry.Entry getFabric(class_2248 block) {
        return this.getEntryMap().get(block);
    }

    @Override
    public void add(class_2248 block, FlammableBlockRegistry.Entry value) {
        this.registeredEntriesBlock.put(block, value);
        this.computedEntries = null;
    }

    @Override
    public void add(class_6862<class_2248> tag, FlammableBlockRegistry.Entry value) {
        this.registeredEntriesTag.put(tag, value);
        this.computedEntries = null;
    }

    @Override
    public void remove(class_2248 block) {
        this.add(block, REMOVED);
    }

    @Override
    public void remove(class_6862<class_2248> tag) {
        this.add(tag, REMOVED);
    }

    @Override
    public void clear(class_2248 block) {
        this.registeredEntriesBlock.remove(block);
        this.computedEntries = null;
    }

    @Override
    public void clear(class_6862<class_2248> tag) {
        this.registeredEntriesTag.remove(tag);
        this.computedEntries = null;
    }

    public static FlammableBlockRegistryImpl getInstance(class_2248 block) {
        if (!(block instanceof FireBlockHooks)) {
            throw new RuntimeException("Not a hookable fire block: " + String.valueOf(block));
        }
        return REGISTRIES.computeIfAbsent(block, FlammableBlockRegistryImpl::new);
    }
}

