/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.datagen.v1.provider;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_11341;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1320;
import net.minecraft.class_156;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1887;
import net.minecraft.class_2248;
import net.minecraft.class_2405;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3448;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7417;
import net.minecraft.class_7784;
import net.minecraft.class_7923;
import org.jetbrains.annotations.ApiStatus;

public abstract class FabricLanguageProvider
implements class_2405 {
    protected final FabricDataOutput dataOutput;
    private final String languageCode;
    private final CompletableFuture<class_7225.class_7874> registryLookup;

    protected FabricLanguageProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
        this(dataOutput, "en_us", registryLookup);
    }

    protected FabricLanguageProvider(FabricDataOutput dataOutput, String languageCode, CompletableFuture<class_7225.class_7874> registryLookup) {
        this.dataOutput = dataOutput;
        this.languageCode = languageCode;
        this.registryLookup = registryLookup;
    }

    public abstract void generateTranslations(class_7225.class_7874 var1, TranslationBuilder var2);

    public CompletableFuture<?> method_10319(class_7403 writer) {
        TreeMap translationEntries = new TreeMap();
        return this.registryLookup.thenCompose(lookup -> {
            this.generateTranslations((class_7225.class_7874)lookup, (key, value) -> {
                Objects.requireNonNull(key);
                Objects.requireNonNull(value);
                if (translationEntries.containsKey(key)) {
                    throw new RuntimeException("Existing translation key found - " + key + " - Duplicate will be ignored.");
                }
                translationEntries.put(key, value);
            });
            JsonObject langEntryJson = new JsonObject();
            for (Map.Entry entry : translationEntries.entrySet()) {
                langEntryJson.addProperty((String)entry.getKey(), (String)entry.getValue());
            }
            return class_2405.method_10320((class_7403)writer, (JsonElement)langEntryJson, (Path)this.getLangFilePath(this.languageCode));
        });
    }

    private Path getLangFilePath(String code) {
        return this.dataOutput.method_45973(class_7784.class_7490.field_39368, "lang").method_44107(class_2960.method_60655((String)this.dataOutput.getModId(), (String)code));
    }

    public String method_10321() {
        return "Language (%s)".formatted(this.languageCode);
    }

    @FunctionalInterface
    @ApiStatus.NonExtendable
    public static interface TranslationBuilder {
        public void add(String var1, String var2);

        default public void add(class_1792 item, String value) {
            this.add(item.method_7876(), value);
        }

        default public void add(class_2248 block, String value) {
            this.add(block.method_63499(), value);
        }

        default public void add(class_5321<class_1761> registryKey, String value) {
            class_1761 group = (class_1761)class_7923.field_44687.method_31140(registryKey);
            class_7417 content = group.method_7737().method_10851();
            if (content instanceof class_2588) {
                class_2588 translatableTextContent = (class_2588)content;
                this.add(translatableTextContent.method_11022(), value);
                return;
            }
            throw new UnsupportedOperationException("Cannot add language entry for ItemGroup (%s) as the display name is not translatable.".formatted(group.method_7737().getString()));
        }

        default public void add(class_1299<?> entityType, String value) {
            this.add(entityType.method_5882(), value);
        }

        default public void addEnchantment(class_5321<class_1887> enchantment, String value) {
            this.add(class_156.method_646((String)"enchantment", (class_2960)enchantment.method_29177()), value);
        }

        default public void add(class_6880<class_1320> entityAttribute, String value) {
            this.add(((class_1320)entityAttribute.comp_349()).method_26830(), value);
        }

        default public void add(class_3448<?> statType, String value) {
            this.add("stat_type." + class_7923.field_41193.method_10221(statType).toString().replace(':', '.'), value);
        }

        default public void add(class_1291 statusEffect, String value) {
            this.add(statusEffect.method_5567(), value);
        }

        default public void add(class_2960 identifier, String value) {
            this.add(identifier.method_42094(), value);
        }

        default public void add(class_6862<?> tagKey, String value) {
            this.add(tagKey.getTranslationKey(), value);
        }

        default public void add(class_3414 sound, String value) {
            this.add(class_156.method_646((String)"subtitles", (class_2960)sound.comp_3319()), value);
        }

        default public void add(Path existingLanguageFile) throws IOException {
            try (BufferedReader reader = Files.newBufferedReader(existingLanguageFile);){
                JsonObject translations = class_11341.method_71359((Reader)reader).getAsJsonObject();
                for (String key : translations.keySet()) {
                    this.add(key, translations.get(key).getAsString());
                }
            }
        }
    }
}

