/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.item;

import java.util.List;

import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import net.fabricmc.fabric.api.item.v1.EnchantmentEvents;
import net.fabricmc.fabric.api.item.v1.EnchantmentSource;
import net.fabricmc.fabric.impl.resource.loader.BuiltinModResourcePackSource;
import net.fabricmc.fabric.impl.resource.loader.FabricResource;
import net.fabricmc.fabric.impl.resource.loader.ModResourcePackCreator;
import net.fabricmc.fabric.mixin.item.EnchantmentBuilderAccessor;
import net.minecraft.class_1887;
import net.minecraft.class_3298;
import net.minecraft.class_5321;
import net.minecraft.class_5352;
import net.minecraft.class_9331;

public class EnchantmentUtil {
	private static final Logger LOGGER = LoggerFactory.getLogger(EnchantmentUtil.class);

	@SuppressWarnings("unchecked")
	@Nullable
	public static class_1887 modify(class_5321<class_1887> key, class_1887 originalEnchantment, EnchantmentSource source) {
		class_1887.class_9700 builder = class_1887.method_60030(originalEnchantment.comp_2687());
		EnchantmentBuilderAccessor accessor = (EnchantmentBuilderAccessor) builder;
		BuilderExtensions builderExtensions = (BuilderExtensions) builder;

		builder.method_60061(originalEnchantment.comp_2688());
		accessor.getEffectMap().method_57839(originalEnchantment.comp_2689());

		originalEnchantment.comp_2689().method_57833()
				.forEach(component -> {
					if (component.comp_2444() instanceof List<?> valueList) {
						// component type cast is checked by the value
						accessor.invokeGetEffectsList((class_9331<List<Object>>) component.comp_2443())
								.addAll(valueList);
					}
				});

		// Reset the modified flag before invoking the event as we setup the builder above
		builderExtensions.fabric$resetModified();

		EnchantmentEvents.MODIFY.invoker().modify(key, builder, source);

		if (builderExtensions.fabric$didModify()) {
			LOGGER.debug("Enchantment {} was modified", key.method_29177());

			return new class_1887(
					originalEnchantment.comp_2686(),
					accessor.getDefinition(),
					accessor.getExclusiveSet(),
					accessor.getEffectMap().method_57838()
			);
		}

		return null;
	}

	public static EnchantmentSource determineSource(class_3298 resource) {
		if (resource != null) {
			class_5352 packSource = ((FabricResource) resource).getFabricPackSource();

			if (packSource == class_5352.field_25348) {
				return EnchantmentSource.VANILLA;
			} else if (packSource == ModResourcePackCreator.RESOURCE_PACK_SOURCE || packSource instanceof BuiltinModResourcePackSource) {
				return EnchantmentSource.MOD;
			}
		}

		// If not builtin or mod, assume external data pack.
		// It might also be a virtual enchantment injected via mixin instead of being loaded
		// from a resource, but we can't determine that here.
		return EnchantmentSource.DATA_PACK;
	}

	private EnchantmentUtil() { }

	public interface BuilderExtensions {
		void fabric$resetModified();
		boolean fabric$didModify();
	}
}
