/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.item.client;

import java.util.List;

import org.jspecify.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;

@Mixin(class_1799.class)
public abstract class ItemStackMixin {
	// Only target the second RETURN, the first RETURN is for no tooltip
	@Inject(method = "getTooltipLines", at = @At(value = "RETURN", ordinal = 1))
	private void getTooltip(class_1792.class_9635 tooltipContext, @Nullable class_1657 entity, class_1836 tooltipType, CallbackInfoReturnable<List<class_2561>> info) {
		ItemTooltipCallback.EVENT.invoker().getTooltip((class_1799) (Object) this, tooltipContext, tooltipType, info.getReturnValue());
	}
}
