/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.item;

import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BrewingStandBlockEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BrewingStandBlockEntity.class})
public class BrewingStandBlockEntityMixin {
    @Unique
    private static final ThreadLocal<ItemStack> REMAINDER_STACK = new ThreadLocal();

    @Inject(method={"doBrew"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;shrink(I)V", shift=At.Shift.AFTER)})
    private static void captureItemStack(Level world, BlockPos pos, NonNullList<ItemStack> slots, CallbackInfo ci, @Local ItemStack itemStack) {
        REMAINDER_STACK.set(itemStack.getRecipeRemainder());
    }

    @Redirect(method={"doBrew"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/Item;getCraftingRemainder()Lnet/minecraft/world/item/ItemStack;"))
    private static ItemStack createStackRecipeRemainder(Item item) {
        ItemStack remainder = REMAINDER_STACK.get();
        REMAINDER_STACK.remove();
        return remainder;
    }
}

