/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.itemgroup.v1;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.ApiStatus;

public class FabricItemGroupEntries
implements CreativeModeTab.Output {
    private final CreativeModeTab.ItemDisplayParameters context;
    private final List<ItemStack> displayStacks;
    private final List<ItemStack> searchTabStacks;

    @ApiStatus.Internal
    public FabricItemGroupEntries(CreativeModeTab.ItemDisplayParameters context, List<ItemStack> displayStacks, List<ItemStack> searchTabStacks) {
        this.context = context;
        this.displayStacks = displayStacks;
        this.searchTabStacks = searchTabStacks;
    }

    public CreativeModeTab.ItemDisplayParameters getContext() {
        return this.context;
    }

    public FeatureFlagSet getEnabledFeatures() {
        return this.context.enabledFeatures();
    }

    public boolean shouldShowOpRestrictedItems() {
        return this.context.hasPermissions();
    }

    public List<ItemStack> getDisplayStacks() {
        return this.displayStacks;
    }

    public List<ItemStack> getSearchTabStacks() {
        return this.searchTabStacks;
    }

    public void accept(ItemStack stack, CreativeModeTab.TabVisibility visibility) {
        if (this.isEnabled(stack)) {
            FabricItemGroupEntries.checkStack(stack);
            switch (visibility) {
                case PARENT_AND_SEARCH_TABS: {
                    this.displayStacks.add(stack);
                    this.searchTabStacks.add(stack);
                    break;
                }
                case PARENT_TAB_ONLY: {
                    this.displayStacks.add(stack);
                    break;
                }
                case SEARCH_TAB_ONLY: {
                    this.searchTabStacks.add(stack);
                }
            }
        }
    }

    public void prepend(ItemStack stack) {
        this.prepend(stack, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
    }

    public void prepend(ItemStack stack, CreativeModeTab.TabVisibility visibility) {
        if (this.isEnabled(stack)) {
            FabricItemGroupEntries.checkStack(stack);
            switch (visibility) {
                case PARENT_AND_SEARCH_TABS: {
                    this.displayStacks.add(0, stack);
                    this.searchTabStacks.add(0, stack);
                    break;
                }
                case PARENT_TAB_ONLY: {
                    this.displayStacks.add(0, stack);
                    break;
                }
                case SEARCH_TAB_ONLY: {
                    this.searchTabStacks.add(0, stack);
                }
            }
        }
    }

    public void prepend(ItemLike item) {
        this.prepend(item, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
    }

    public void prepend(ItemLike item, CreativeModeTab.TabVisibility visibility) {
        this.prepend(new ItemStack(item), visibility);
    }

    public void addAfter(ItemLike afterLast, ItemStack ... newStack) {
        this.addAfter(afterLast, Arrays.asList(newStack));
    }

    public void addAfter(ItemStack afterLast, ItemStack ... newStack) {
        this.addAfter(afterLast, Arrays.asList(newStack));
    }

    public void addAfter(ItemLike afterLast, ItemLike ... newItem) {
        this.addAfter(afterLast, Arrays.stream(newItem).map(ItemStack::new).toList());
    }

    public void addAfter(ItemStack afterLast, ItemLike ... newItem) {
        this.addAfter(afterLast, Arrays.stream(newItem).map(ItemStack::new).toList());
    }

    public void addAfter(ItemLike afterLast, Collection<ItemStack> newStacks) {
        this.addAfter(afterLast, newStacks, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
    }

    public void addAfter(ItemStack afterLast, Collection<ItemStack> newStacks) {
        this.addAfter(afterLast, newStacks, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
    }

    public void addAfter(ItemLike afterLast, Collection<ItemStack> newStacks, CreativeModeTab.TabVisibility visibility) {
        if ((newStacks = this.getEnabledStacks(newStacks)).isEmpty()) {
            return;
        }
        switch (visibility) {
            case PARENT_AND_SEARCH_TABS: {
                FabricItemGroupEntries.addAfter(afterLast, newStacks, this.displayStacks);
                FabricItemGroupEntries.addAfter(afterLast, newStacks, this.searchTabStacks);
                break;
            }
            case PARENT_TAB_ONLY: {
                FabricItemGroupEntries.addAfter(afterLast, newStacks, this.displayStacks);
                break;
            }
            case SEARCH_TAB_ONLY: {
                FabricItemGroupEntries.addAfter(afterLast, newStacks, this.searchTabStacks);
            }
        }
    }

    public void addAfter(ItemStack afterLast, Collection<ItemStack> newStacks, CreativeModeTab.TabVisibility visibility) {
        if ((newStacks = this.getEnabledStacks(newStacks)).isEmpty()) {
            return;
        }
        switch (visibility) {
            case PARENT_AND_SEARCH_TABS: {
                FabricItemGroupEntries.addAfter(afterLast, newStacks, this.displayStacks);
                FabricItemGroupEntries.addAfter(afterLast, newStacks, this.searchTabStacks);
                break;
            }
            case PARENT_TAB_ONLY: {
                FabricItemGroupEntries.addAfter(afterLast, newStacks, this.displayStacks);
                break;
            }
            case SEARCH_TAB_ONLY: {
                FabricItemGroupEntries.addAfter(afterLast, newStacks, this.searchTabStacks);
            }
        }
    }

    public void addAfter(Predicate<ItemStack> afterLast, Collection<ItemStack> newStacks, CreativeModeTab.TabVisibility visibility) {
        if ((newStacks = this.getEnabledStacks(newStacks)).isEmpty()) {
            return;
        }
        switch (visibility) {
            case PARENT_AND_SEARCH_TABS: {
                FabricItemGroupEntries.addAfter(afterLast, newStacks, this.displayStacks);
                FabricItemGroupEntries.addAfter(afterLast, newStacks, this.searchTabStacks);
                break;
            }
            case PARENT_TAB_ONLY: {
                FabricItemGroupEntries.addAfter(afterLast, newStacks, this.displayStacks);
                break;
            }
            case SEARCH_TAB_ONLY: {
                FabricItemGroupEntries.addAfter(afterLast, newStacks, this.searchTabStacks);
            }
        }
    }

    public void addBefore(ItemLike beforeFirst, ItemStack ... newStack) {
        this.addBefore(beforeFirst, Arrays.asList(newStack));
    }

    public void addBefore(ItemStack beforeFirst, ItemStack ... newStack) {
        this.addBefore(beforeFirst, Arrays.asList(newStack));
    }

    public void addBefore(ItemLike beforeFirst, ItemLike ... newItem) {
        this.addBefore(beforeFirst, Arrays.stream(newItem).map(ItemStack::new).toList());
    }

    public void addBefore(ItemStack beforeFirst, ItemLike ... newItem) {
        this.addBefore(beforeFirst, Arrays.stream(newItem).map(ItemStack::new).toList());
    }

    public void addBefore(ItemLike beforeFirst, Collection<ItemStack> newStacks) {
        this.addBefore(beforeFirst, newStacks, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
    }

    public void addBefore(ItemStack beforeFirst, Collection<ItemStack> newStacks) {
        this.addBefore(beforeFirst, newStacks, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
    }

    public void addBefore(ItemLike beforeFirst, Collection<ItemStack> newStacks, CreativeModeTab.TabVisibility visibility) {
        if ((newStacks = this.getEnabledStacks(newStacks)).isEmpty()) {
            return;
        }
        switch (visibility) {
            case PARENT_AND_SEARCH_TABS: {
                FabricItemGroupEntries.addBefore(beforeFirst, newStacks, this.displayStacks);
                FabricItemGroupEntries.addBefore(beforeFirst, newStacks, this.searchTabStacks);
                break;
            }
            case PARENT_TAB_ONLY: {
                FabricItemGroupEntries.addBefore(beforeFirst, newStacks, this.displayStacks);
                break;
            }
            case SEARCH_TAB_ONLY: {
                FabricItemGroupEntries.addBefore(beforeFirst, newStacks, this.searchTabStacks);
            }
        }
    }

    public void addBefore(ItemStack beforeFirst, Collection<ItemStack> newStacks, CreativeModeTab.TabVisibility visibility) {
        if ((newStacks = this.getEnabledStacks(newStacks)).isEmpty()) {
            return;
        }
        switch (visibility) {
            case PARENT_AND_SEARCH_TABS: {
                FabricItemGroupEntries.addBefore(beforeFirst, newStacks, this.displayStacks);
                FabricItemGroupEntries.addBefore(beforeFirst, newStacks, this.searchTabStacks);
                break;
            }
            case PARENT_TAB_ONLY: {
                FabricItemGroupEntries.addBefore(beforeFirst, newStacks, this.displayStacks);
                break;
            }
            case SEARCH_TAB_ONLY: {
                FabricItemGroupEntries.addBefore(beforeFirst, newStacks, this.searchTabStacks);
            }
        }
    }

    public void addBefore(Predicate<ItemStack> beforeFirst, Collection<ItemStack> newStacks, CreativeModeTab.TabVisibility visibility) {
        if ((newStacks = this.getEnabledStacks(newStacks)).isEmpty()) {
            return;
        }
        switch (visibility) {
            case PARENT_AND_SEARCH_TABS: {
                FabricItemGroupEntries.addBefore(beforeFirst, newStacks, this.displayStacks);
                FabricItemGroupEntries.addBefore(beforeFirst, newStacks, this.searchTabStacks);
                break;
            }
            case PARENT_TAB_ONLY: {
                FabricItemGroupEntries.addBefore(beforeFirst, newStacks, this.displayStacks);
                break;
            }
            case SEARCH_TAB_ONLY: {
                FabricItemGroupEntries.addBefore(beforeFirst, newStacks, this.searchTabStacks);
            }
        }
    }

    private boolean isEnabled(ItemStack stack) {
        return stack.getItem().isEnabled(this.getEnabledFeatures());
    }

    private Collection<ItemStack> getEnabledStacks(Collection<ItemStack> newStacks) {
        if (newStacks.stream().allMatch(this::isEnabled)) {
            return newStacks;
        }
        return newStacks.stream().filter(this::isEnabled).toList();
    }

    private static void addBefore(Predicate<ItemStack> predicate, Collection<ItemStack> newStacks, List<ItemStack> addTo) {
        FabricItemGroupEntries.checkStacks(newStacks);
        for (int i = 0; i < addTo.size(); ++i) {
            if (!predicate.test(addTo.get(i))) continue;
            addTo.subList(i, i).addAll(newStacks);
            return;
        }
        addTo.addAll(newStacks);
    }

    private static void addAfter(Predicate<ItemStack> predicate, Collection<ItemStack> newStacks, List<ItemStack> addTo) {
        FabricItemGroupEntries.checkStacks(newStacks);
        for (int i = addTo.size() - 1; i >= 0; --i) {
            if (!predicate.test(addTo.get(i))) continue;
            addTo.subList(i + 1, i + 1).addAll(newStacks);
            return;
        }
        addTo.addAll(newStacks);
    }

    private static void addBefore(ItemStack anchor, Collection<ItemStack> newStacks, List<ItemStack> addTo) {
        FabricItemGroupEntries.checkStacks(newStacks);
        for (int i = 0; i < addTo.size(); ++i) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)anchor, (ItemStack)addTo.get(i))) continue;
            addTo.subList(i, i).addAll(newStacks);
            return;
        }
        addTo.addAll(newStacks);
    }

    private static void addAfter(ItemStack anchor, Collection<ItemStack> newStacks, List<ItemStack> addTo) {
        FabricItemGroupEntries.checkStacks(newStacks);
        for (int i = addTo.size() - 1; i >= 0; --i) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)anchor, (ItemStack)addTo.get(i))) continue;
            addTo.subList(i + 1, i + 1).addAll(newStacks);
            return;
        }
        addTo.addAll(newStacks);
    }

    private static void addBefore(ItemLike anchor, Collection<ItemStack> newStacks, List<ItemStack> addTo) {
        FabricItemGroupEntries.checkStacks(newStacks);
        Item anchorItem = anchor.asItem();
        for (int i = 0; i < addTo.size(); ++i) {
            if (!addTo.get(i).is(anchorItem)) continue;
            addTo.subList(i, i).addAll(newStacks);
            return;
        }
        addTo.addAll(newStacks);
    }

    private static void addAfter(ItemLike anchor, Collection<ItemStack> newStacks, List<ItemStack> addTo) {
        FabricItemGroupEntries.checkStacks(newStacks);
        Item anchorItem = anchor.asItem();
        for (int i = addTo.size() - 1; i >= 0; --i) {
            if (!addTo.get(i).is(anchorItem)) continue;
            addTo.subList(i + 1, i + 1).addAll(newStacks);
            return;
        }
        addTo.addAll(newStacks);
    }

    private static void checkStacks(Collection<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            FabricItemGroupEntries.checkStack(stack);
        }
    }

    private static void checkStack(ItemStack stack) {
        if (stack.isEmpty()) {
            throw new IllegalArgumentException("Cannot add empty stack");
        }
        if (stack.getCount() != 1) {
            throw new IllegalArgumentException("Stack size must be exactly 1 for stack: " + String.valueOf(stack));
        }
    }
}

