/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.event.lifecycle;

import java.util.List;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import net.fabricmc.fabric.api.event.lifecycle.v1.CommonLifecycleEvents;
import net.minecraft.class_12096;
import net.minecraft.class_2170;
import net.minecraft.class_5350;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_7659;
import net.minecraft.class_7699;
import net.minecraft.class_7780;

@Mixin(class_5350.class)
public class ReloadableServerResourcesMixin {
	@Unique
	private class_5455 dynamicRegistryManager;

	@Inject(method = "<init>", at = @At("TAIL"))
	private void init(class_7780<class_7659> combinedDynamicRegistries, class_7225.class_7874 registries, class_7699 enabledFeatures, class_2170.class_5364 environment, List pendingTagLoads, class_12096 permissionPredicate, CallbackInfo ci) {
		dynamicRegistryManager = combinedDynamicRegistries.method_45926();
	}

	@Inject(method = "updateStaticRegistryTags", at = @At("TAIL"))
	private void hookRefresh(CallbackInfo ci) {
		CommonLifecycleEvents.TAGS_LOADED.invoker().onTagsLoaded(dynamicRegistryManager, false);
	}
}
