/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.event.lifecycle;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerChunkEvents;
import net.fabricmc.fabric.impl.event.lifecycle.ChunkLevelTypeEventTracker;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_2821;
import net.minecraft.class_3194;
import net.minecraft.class_9310;
import net.minecraft.class_9312;
import net.minecraft.class_9761;

@Mixin(class_9310.class)
abstract class ChunkStatusTasksMixin {
	@Unique
	private static final class_3194[] fabric_CHUNK_LEVEL_TYPES = class_3194.values(); // values() clones the internal array each call, so cache the return

	@Inject(method = "method_60553", at = @At("TAIL"))
	private static void onChunkLoad(class_2791 chunk, class_9312 chunkGenerationContext, class_9761 chunkHolder, CallbackInfoReturnable<class_2791> callbackInfoReturnable) {
		class_2818 worldChunk = (class_2818) callbackInfoReturnable.getReturnValue();

		// We fire the event at TAIL since the chunk is guaranteed to be a WorldChunk then.
		ServerChunkEvents.CHUNK_LOAD.invoker().onChunkLoad(chunkGenerationContext.comp_2434(), worldChunk);

		if (!(chunk instanceof class_2821)) {
			ServerChunkEvents.CHUNK_GENERATE.invoker().onChunkGenerate(chunkGenerationContext.comp_2434(), worldChunk);
		}

		// Handles the case where the chunk becomes accessible from being completed unloaded, only fires if chunkHolder has been set to at least that level type
		ChunkLevelTypeEventTracker levelTypeTracker = (ChunkLevelTypeEventTracker) chunkHolder;

		for (int i = levelTypeTracker.fabric_getCurrentEventLevelType().ordinal(); i < chunkHolder.method_60474().ordinal(); i++) {
			class_3194 oldLevelType = fabric_CHUNK_LEVEL_TYPES[i];
			class_3194 newLevelType = fabric_CHUNK_LEVEL_TYPES[i+1];
			ServerChunkEvents.CHUNK_LEVEL_TYPE_CHANGE.invoker().onChunkLevelTypeChange(chunkGenerationContext.comp_2434(), worldChunk, oldLevelType, newLevelType);
			levelTypeTracker.fabric_setCurrentEventLevelType(newLevelType);
		}
	}
}
