/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.event.lifecycle.client;

import com.llamalad7.mixinextras.sugar.Local;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientChunkEvents;
import net.minecraft.client.multiplayer.ClientChunkCache;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ClientChunkCache.class})
public abstract class ClientChunkCacheMixin {
    @Final
    @Shadow
    ClientLevel level;

    @Inject(method={"replaceWithPacketData"}, at={@At(value="TAIL")})
    private void onChunkLoad(int x, int z, FriendlyByteBuf packetByteBuf, Map<Heightmap.Types, long[]> highmap, Consumer<ClientboundLevelChunkPacketData.BlockEntityTagOutput> consumer, CallbackInfoReturnable<LevelChunk> info) {
        ((ClientChunkEvents.Load)ClientChunkEvents.CHUNK_LOAD.invoker()).onChunkLoad(this.level, (LevelChunk)info.getReturnValue());
    }

    @Inject(method={"replaceWithPacketData"}, at={@At(value="NEW", target="net/minecraft/world/level/chunk/LevelChunk", shift=At.Shift.BEFORE)})
    private void onChunkUnload(int x, int z, FriendlyByteBuf buf, Map<Heightmap.Types, long[]> highmap, Consumer<ClientboundLevelChunkPacketData.BlockEntityTagOutput> consumer, CallbackInfoReturnable<LevelChunk> info, @Local LevelChunk worldChunk) {
        if (worldChunk != null) {
            ((ClientChunkEvents.Unload)ClientChunkEvents.CHUNK_UNLOAD.invoker()).onChunkUnload(this.level, worldChunk);
        }
    }

    @Inject(method={"drop"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientChunkCache$Storage;drop(ILnet/minecraft/world/level/chunk/LevelChunk;)V")})
    private void onChunkUnload(ChunkPos pos, CallbackInfo ci, @Local LevelChunk chunk) {
        ((ClientChunkEvents.Unload)ClientChunkEvents.CHUNK_UNLOAD.invoker()).onChunkUnload(this.level, chunk);
    }

    @Inject(method={"updateViewRadius"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientChunkCache$Storage;inRange(II)Z")})
    private void onUpdateLoadDistance(int loadDistance, CallbackInfo ci, @Local ClientChunkCache.Storage clientChunkMap, @Local LevelChunk oldChunk, @Local ChunkPos chunkPos) {
        if (!clientChunkMap.inRange(chunkPos.x, chunkPos.z)) {
            ((ClientChunkEvents.Unload)ClientChunkEvents.CHUNK_UNLOAD.invoker()).onChunkUnload(this.level, oldChunk);
        }
    }
}

