/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.client.model.loading;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.annotations.UnmodifiableView;
import org.jspecify.annotations.Nullable;
import net.fabricmc.fabric.api.client.model.loading.v1.CompositeBlockStateModel;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_5699;
import net.minecraft.class_5819;
import net.minecraft.class_7775;

public class CompositeBlockStateModelImpl implements CompositeBlockStateModel {
	private final class_1087[] models;
	@UnmodifiableView
	private final List<class_1087> modelsView;

	public CompositeBlockStateModelImpl(class_1087[] models) {
		this.models = models;
		modelsView = Arrays.asList(models);
	}

	public static CompositeBlockStateModelImpl of(List<class_1087> models) {
		if (models.isEmpty()) {
			throw new IllegalArgumentException("Models list must not be empty");
		}

		for (class_1087 model : models) Objects.requireNonNull(model, "Model cannot be null");
		return new CompositeBlockStateModelImpl(models.toArray(class_1087[]::new));
	}

	@Override
	@Unmodifiable
	public List<class_1087> models() {
		return modelsView;
	}

	@Override
	public void method_68513(class_5819 random, List<class_10889> parts) {
		long seed = random.method_43055();

		for (class_1087 model : models) {
			random.method_43052(seed);
			model.method_68513(random, parts);
		}
	}

	@Override
	public void emitQuads(QuadEmitter emitter, class_1920 blockView, class_2338 pos, class_2680 state, class_5819 random, Predicate<@Nullable class_2350> cullTest) {
		long seed = random.method_43055();

		for (class_1087 model : models) {
			random.method_43052(seed);
			model.emitQuads(emitter, blockView, pos, state, random, cullTest);
		}
	}

	@Override
	@Nullable
	public Object createGeometryKey(class_1920 blockView, class_2338 pos, class_2680 state, class_5819 random) {
		int count = models.length;
		long seed = random.method_43055();

		if (count == 1) {
			random.method_43052(seed);
			return models[0].createGeometryKey(blockView, pos, state, random);
		} else {
			List<Object> subkeys = new ArrayList<>(count);

			for (class_1087 submodel : models) {
				random.method_43052(seed);
				Object subkey = submodel.createGeometryKey(blockView, pos, state, random);

				if (subkey == null) {
					return null;
				}

				subkeys.add(subkey);
			}

			record Key(List<Object> subkeys) {
			}

			return new Key(subkeys);
		}
	}

	@Override
	public class_1058 method_68511() {
		return models[0].method_68511();
	}

	@Override
	public class_1058 particleSprite(class_1920 blockView, class_2338 pos, class_2680 state) {
		return models[0].particleSprite(blockView, pos, state);
	}

	public record Unbaked(@Unmodifiable List<class_1087.class_10892> models) implements CompositeBlockStateModel.Unbaked {
		public static final MapCodec<net.fabricmc.fabric.impl.client.model.loading.CompositeBlockStateModelImpl.Unbaked> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
				class_5699.method_36973(class_1087.class_10892.field_57944.listOf()).fieldOf("models").forGetter(net.fabricmc.fabric.impl.client.model.loading.CompositeBlockStateModelImpl.Unbaked::models)
		).apply(instance, net.fabricmc.fabric.impl.client.model.loading.CompositeBlockStateModelImpl.Unbaked::new));

		public static net.fabricmc.fabric.impl.client.model.loading.CompositeBlockStateModelImpl.Unbaked of(List<class_1087.class_10892> models) {
			if (models.isEmpty()) {
				throw new IllegalArgumentException("Models list must not be empty");
			}

			for (class_1087.class_10892 model : models) Objects.requireNonNull(model, "Model cannot be null");
			return new net.fabricmc.fabric.impl.client.model.loading.CompositeBlockStateModelImpl.Unbaked(List.copyOf(models));
		}

		@Override
		public MapCodec<net.fabricmc.fabric.impl.client.model.loading.CompositeBlockStateModelImpl.Unbaked> codec() {
			return CODEC;
		}

		@Override
		public class_1087 method_68521(class_7775 baker) {
			class_1087[] bakedModels = new class_1087[models.size()];

			for (int i = 0; i < models.size(); i++) {
				bakedModels[i] = models.get(i).method_68521(baker);
			}

			return new CompositeBlockStateModelImpl(bakedModels);
		}

		@Override
		public void method_62326(class_10103 resolver) {
			models.forEach(model -> model.method_62326(resolver));
		}
	}
}
