/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.client.model.loading.v1;

import java.util.function.BiFunction;
import net.fabricmc.fabric.api.client.model.loading.v1.UnbakedExtraModel;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.block.model.SimpleModelWrapper;
import net.minecraft.client.renderer.block.model.SingleVariant;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.client.resources.model.ResolvedModel;
import net.minecraft.resources.Identifier;

public final class SimpleUnbakedExtraModel<T>
implements UnbakedExtraModel<T> {
    private final Identifier model;
    private final BiFunction<ResolvedModel, ModelBaker, T> bake;

    public SimpleUnbakedExtraModel(Identifier model, BiFunction<ResolvedModel, ModelBaker, T> bake) {
        this.model = model;
        this.bake = bake;
    }

    public static SimpleUnbakedExtraModel<BlockStateModel> blockStateModel(Identifier model) {
        return SimpleUnbakedExtraModel.blockStateModel(model, (ModelState)BlockModelRotation.IDENTITY);
    }

    public static SimpleUnbakedExtraModel<BlockStateModel> blockStateModel(Identifier model, ModelState settings) {
        return new SimpleUnbakedExtraModel<BlockStateModel>(model, (baked, baker) -> {
            TextureSlots textures = baked.getTopTextureSlots();
            return new SingleVariant((BlockModelPart)new SimpleModelWrapper(baked.bakeTopGeometry(textures, baker, settings), baked.getTopAmbientOcclusion(), baked.resolveParticleSprite(textures, baker)));
        });
    }

    public void resolveDependencies(ResolvableModel.Resolver resolver) {
        resolver.markDependency(this.model);
    }

    @Override
    public T bake(ModelBaker baker) {
        return this.bake.apply(baker.getModel(this.model), baker);
    }
}

