/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.client.model.loading.v1.wrapper;

import java.util.List;
import java.util.function.Predicate;

import org.jetbrains.annotations.Nullable;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_5819;

/**
 * A simple implementation of {@link class_1087} that delegates all method calls to the {@link #wrapped} field.
 * Implementations must set the {@link #wrapped} field somehow.
 */
public abstract class WrapperBlockStateModel implements class_1087 {
	protected class_1087 wrapped;

	protected WrapperBlockStateModel() {
	}

	protected WrapperBlockStateModel(class_1087 wrapped) {
		this.wrapped = wrapped;
	}

	@Override
	public void method_68513(class_5819 random, List<class_10889> parts) {
		wrapped.method_68513(random, parts);
	}

	@Override
	public List<class_10889> method_68512(class_5819 random) {
		return wrapped.method_68512(random);
	}

	@Override
	public class_1058 method_68511() {
		return wrapped.method_68511();
	}

	@Override
	public void emitQuads(QuadEmitter emitter, class_1920 blockView, class_2338 pos, class_2680 state, class_5819 random, Predicate<@Nullable class_2350> cullTest) {
		wrapped.emitQuads(emitter, blockView, pos, state, random, cullTest);
	}

	@Override
	@Nullable
	public Object createGeometryKey(class_1920 blockView, class_2338 pos, class_2680 state, class_5819 random) {
		return wrapped.createGeometryKey(blockView, pos, state, random);
	}

	@Override
	public class_1058 particleSprite(class_1920 blockView, class_2338 pos, class_2680 state) {
		return wrapped.particleSprite(blockView, pos, state);
	}
}
