/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.client.model.loading;

import java.util.List;
import java.util.function.Function;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import net.fabricmc.fabric.impl.client.model.loading.CustomUnbakedBlockStateModelRegistry;
import net.minecraft.class_1087;
import net.minecraft.class_10893;
import net.minecraft.class_1097;
import net.minecraft.class_6010;
import net.minecraft.class_813;

@Mixin(class_1087.class_10892.class)
interface BlockStateModelUnbakedMixin {
	@Redirect(method = "<clinit>()V", at = @At(value = "INVOKE", target = "com/mojang/serialization/Codec.flatComapMap(Ljava/util/function/Function;Ljava/util/function/Function;)Lcom/mojang/serialization/Codec;", ordinal = 0))
	private static Codec<class_1097.class_10898> replaceWeightedCodec(Codec<List<class_6010<class_813>>> codec, Function<?, ?> to, Function<?, ?> from) {
		return CustomUnbakedBlockStateModelRegistry.WEIGHTED_MODEL_CODEC;
	}

	@Redirect(method = "<clinit>()V", at = @At(value = "INVOKE", target = "com/mojang/serialization/Codec.flatComapMap(Ljava/util/function/Function;Ljava/util/function/Function;)Lcom/mojang/serialization/Codec;", ordinal = 1))
	private static Codec<class_1087.class_10892> replaceCodec(Codec<Either<class_1097.class_10898, class_10893.class_10894>> codec, Function<?, ?> to, Function<?, ?> from) {
		return CustomUnbakedBlockStateModelRegistry.MODEL_CODEC;
	}
}
