/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.networking;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import com.llamalad7.mixinextras.sugar.Local;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import net.fabricmc.fabric.impl.networking.ChannelInfoHolder;
import net.fabricmc.fabric.impl.networking.NetworkHandlerExtensions;
import net.fabricmc.fabric.impl.networking.PacketCallbackListener;
import net.fabricmc.fabric.impl.networking.PayloadTypeRegistryImpl;
import net.fabricmc.fabric.impl.networking.VanillaPacketTypes;
import net.fabricmc.fabric.impl.networking.splitter.FabricPacketMerger;
import net.fabricmc.fabric.impl.networking.splitter.FabricPacketSplitter;
import net.minecraft.class_2535;
import net.minecraft.class_2539;
import net.minecraft.class_2543;
import net.minecraft.class_2545;
import net.minecraft.class_2547;
import net.minecraft.class_2596;
import net.minecraft.class_2598;
import net.minecraft.class_2960;
import net.minecraft.class_9127;
import net.minecraft.class_9130;

@Mixin(class_2535.class)
abstract class ClientConnectionMixin implements ChannelInfoHolder {
	@Shadow
	private class_2547 packetListener;

	@Unique
	private Map<class_2539, Collection<class_2960>> playChannels;

	@Inject(method = "<init>", at = @At("RETURN"))
	private void initAddedFields(class_2598 side, CallbackInfo ci) {
		this.playChannels = new ConcurrentHashMap<>();
	}

	@Inject(method = "sendImmediately", at = @At(value = "FIELD", target = "Lnet/minecraft/network/ClientConnection;packetsSentCounter:I"))
	private void checkPacket(class_2596<?> packet, ChannelFutureListener callback, boolean flush, CallbackInfo ci) {
		if (this.packetListener instanceof PacketCallbackListener) {
			((PacketCallbackListener) this.packetListener).sent(packet);
		}
	}

	@Inject(method = "setPacketListener", at = @At("HEAD"))
	private void unwatchAddon(class_9127<?> state, class_2547 listener, CallbackInfo ci) {
		if (this.packetListener instanceof NetworkHandlerExtensions oldListener) {
			oldListener.getAddon().endSession();
		}
	}

	@Inject(method = "channelInactive", at = @At("HEAD"))
	private void disconnectAddon(ChannelHandlerContext channelHandlerContext, CallbackInfo ci) {
		if (packetListener instanceof NetworkHandlerExtensions extension) {
			extension.getAddon().handleDisconnect();
		}
	}

	@Inject(method = "handleDisconnection", at = @At(value = "INVOKE", target = "Lnet/minecraft/network/listener/PacketListener;onDisconnected(Lnet/minecraft/network/DisconnectionInfo;)V"))
	private void disconnectAddon(CallbackInfo ci) {
		if (packetListener instanceof NetworkHandlerExtensions extension) {
			extension.getAddon().handleDisconnect();
		}
	}

	@ModifyArg(method = "transitionInbound", at = @At(value = "INVOKE", target = "Lio/netty/channel/Channel;writeAndFlush(Ljava/lang/Object;)Lio/netty/channel/ChannelFuture;"))
	private Object injectFabricPacketSlitterHandlerInbound(Object transitioner, @Local(argsOnly = true) class_9127<?> state) {
		PayloadTypeRegistryImpl<?> payloadTypeRegistry = PayloadTypeRegistryImpl.get(state);

		if (payloadTypeRegistry == null) {
			return transitioner;
		}

		return ((class_9130.class_9132) transitioner).andThen((context) -> {
			FabricPacketMerger merger = new FabricPacketMerger(context.pipeline().get(class_2543.class), payloadTypeRegistry, VanillaPacketTypes.get(state));
			context.pipeline().addAfter("decoder", "fabric:merger", merger);
		});
	}

	@ModifyArg(method = "transitionOutbound", at = @At(value = "INVOKE", target = "Lio/netty/channel/Channel;writeAndFlush(Ljava/lang/Object;)Lio/netty/channel/ChannelFuture;"))
	private Object injectFabricPacketSlitterHandlerOutbound(Object transitioner, @Local(argsOnly = true) class_9127<?> state) {
		PayloadTypeRegistryImpl<?> payloadTypeRegistry = PayloadTypeRegistryImpl.get(state);

		if (payloadTypeRegistry == null) {
			return transitioner;
		}

		return ((class_9130.class_9134) transitioner).andThen((context) -> {
			FabricPacketSplitter splitter = new FabricPacketSplitter(context.pipeline().get(class_2545.class), payloadTypeRegistry);
			context.pipeline().addAfter("encoder", "fabric:splitter", splitter);
		});
	}

	@Override
	public Collection<class_2960> fabric_getPendingChannelsNames(class_2539 state) {
		return this.playChannels.computeIfAbsent(state, (key) -> Collections.newSetFromMap(new ConcurrentHashMap<>()));
	}
}
