/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.networking.splitter;

import io.netty.buffer.ByteBuf;
import net.fabricmc.fabric.impl.networking.NetworkingImpl;
import net.minecraft.class_2545;
import net.minecraft.class_2547;
import net.minecraft.class_2596;
import net.minecraft.class_2598;
import net.minecraft.class_2960;
import net.minecraft.class_9145;

/**
 * A fake packet implementation used to pass already encoded data from {@link FabricPacketSplitter} to {@link class_2545}.
 * Allows to avoid requiring to serialize the packet twice.
 */
public record PassthroughPacket(ByteBuf buf) implements class_2596<class_2547> {
	private static final class_9145<? extends class_2596<class_2547>> FAKE_TYPE = new class_9145<>(class_2598.field_11941, class_2960.method_60655(NetworkingImpl.MOD_ID, "passthrough"));

	@Override
	public class_9145<? extends class_2596<class_2547>> method_65080() {
		return FAKE_TYPE;
	}

	@Override
	public void method_65081(class_2547 listener) {
		throw new UnsupportedOperationException("This is not a real packet!");
	}
}
