/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.networking;

import java.util.List;
import java.util.function.Consumer;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import io.netty.channel.ChannelHandlerContext;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import net.fabricmc.fabric.impl.networking.FabricCustomPayloadPacketCodec;
import net.fabricmc.fabric.impl.networking.GenericPayloadAccessor;
import net.fabricmc.fabric.impl.networking.PayloadTypeRegistryImpl;
import net.fabricmc.fabric.impl.networking.splitter.FabricPacketSplitter;
import net.fabricmc.fabric.impl.networking.splitter.SplittablePacket;
import net.minecraft.class_2540;
import net.minecraft.class_2545;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

@Mixin(class_2658.class)
public class CustomPayloadS2CPacketMixin implements SplittablePacket, GenericPayloadAccessor {
	@Shadow
	@Final
	private class_8710 payload;

	@WrapOperation(
			method = "<clinit>",
			at = @At(
					value = "INVOKE",
					target = "Lnet/minecraft/network/packet/CustomPayload;createCodec(Lnet/minecraft/network/packet/CustomPayload$CodecFactory;Ljava/util/List;)Lnet/minecraft/network/codec/PacketCodec;",
					ordinal = 0
			)
	)
	private static class_9139<class_9129, class_8710> wrapPlayCodec(class_8710.class_9153<class_9129> unknownCodecFactory, List<class_8710.class_9155<class_9129, ?>> types, Operation<class_9139<class_9129, class_8710>> original) {
		class_9139<class_9129, class_8710> codec = original.call(unknownCodecFactory, types);
		FabricCustomPayloadPacketCodec<class_9129> fabricCodec = (FabricCustomPayloadPacketCodec<class_9129>) codec;
		fabricCodec.fabric_setPacketCodecProvider((packetByteBuf, identifier) -> PayloadTypeRegistryImpl.PLAY_S2C.get(identifier));
		return codec;
	}

	@WrapOperation(
			method = "<clinit>",
			at = @At(
					value = "INVOKE",
					target = "Lnet/minecraft/network/packet/CustomPayload;createCodec(Lnet/minecraft/network/packet/CustomPayload$CodecFactory;Ljava/util/List;)Lnet/minecraft/network/codec/PacketCodec;",
					ordinal = 1
			)
	)
	private static class_9139<class_2540, class_8710> wrapConfigCodec(class_8710.class_9153<class_2540> unknownCodecFactory, List<class_8710.class_9155<class_2540, ?>> types, Operation<class_9139<class_2540, class_8710>> original) {
		class_9139<class_2540, class_8710> codec = original.call(unknownCodecFactory, types);
		FabricCustomPayloadPacketCodec<class_2540> fabricCodec = (FabricCustomPayloadPacketCodec<class_2540>) codec;
		fabricCodec.fabric_setPacketCodecProvider((packetByteBuf, identifier) -> PayloadTypeRegistryImpl.CONFIGURATION_S2C.get(identifier));
		return codec;
	}

	@Override
	public void fabric_split(PayloadTypeRegistryImpl<?> payloadTypeRegistry, ChannelHandlerContext channelHandlerContext, class_2545<?> encoder, class_2596<?> packet, Consumer<class_2596<?>> consumer) throws Exception {
		int size = payloadTypeRegistry.getMaxPacketSize(this.payload.method_56479().comp_2242());

		if (size == -1) {
			consumer.accept((class_2596<?>) this);
			return;
		}

		FabricPacketSplitter.genericPacketSplitter(this.payload.method_56479().comp_2242(), channelHandlerContext, encoder, packet, class_2658::new, consumer, FabricPacketSplitter.SAFE_S2C_SPLIT_SIZE, size);
	}

	@Override
	public class_8710 fabric_payload() {
		return this.payload;
	}
}
