/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.networking.v1;

import java.util.Objects;
import java.util.Set;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.impl.networking.server.ServerNetworkingImpl;
import net.fabricmc.fabric.mixin.networking.accessor.ServerCommonNetworkHandlerAccessor;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_8610;
import net.minecraft.class_8705;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.Nullable;

public final class ServerConfigurationNetworking {
    public static <T extends class_8710> boolean registerGlobalReceiver(class_8710.class_9154<T> type, ConfigurationPacketHandler<T> handler) {
        return ServerNetworkingImpl.CONFIGURATION.registerGlobalReceiver(type.comp_2242(), handler);
    }

    public static @Nullable ConfigurationPacketHandler<?> unregisterGlobalReceiver(class_2960 id) {
        return ServerNetworkingImpl.CONFIGURATION.unregisterGlobalReceiver(id);
    }

    public static Set<class_2960> getGlobalReceivers() {
        return ServerNetworkingImpl.CONFIGURATION.getChannels();
    }

    public static <T extends class_8710> boolean registerReceiver(class_8610 networkHandler, class_8710.class_9154<T> type, ConfigurationPacketHandler<T> handler) {
        return ServerNetworkingImpl.getAddon(networkHandler).registerChannel(type.comp_2242(), handler);
    }

    public static @Nullable ConfigurationPacketHandler<?> unregisterReceiver(class_8610 networkHandler, class_2960 id) {
        return (ConfigurationPacketHandler)ServerNetworkingImpl.getAddon(networkHandler).unregisterChannel(id);
    }

    public static Set<class_2960> getReceived(class_8610 handler) {
        Objects.requireNonNull(handler, "Server configuration network handler cannot be null");
        return ServerNetworkingImpl.getAddon(handler).getReceivableChannels();
    }

    public static Set<class_2960> getSendable(class_8610 handler) {
        Objects.requireNonNull(handler, "Server configuration network handler cannot be null");
        return ServerNetworkingImpl.getAddon(handler).getSendableChannels();
    }

    public static boolean canSend(class_8610 handler, class_2960 channelName) {
        Objects.requireNonNull(handler, "Server configuration network handler cannot be null");
        Objects.requireNonNull(channelName, "Channel name cannot be null");
        return ServerNetworkingImpl.getAddon(handler).getSendableChannels().contains(channelName);
    }

    public static boolean canSend(class_8610 handler, class_8710.class_9154<?> id) {
        Objects.requireNonNull(handler, "Server configuration network handler cannot be null");
        Objects.requireNonNull(id, "Payload id cannot be null");
        return ServerNetworkingImpl.getAddon(handler).getSendableChannels().contains(id.comp_2242());
    }

    public static class_2596<class_8705> createS2CPacket(class_8710 payload) {
        Objects.requireNonNull(payload, "Payload cannot be null");
        Objects.requireNonNull(payload.method_56479(), "CustomPayload#getId() cannot return null for payload class: " + String.valueOf(payload.getClass()));
        return ServerNetworkingImpl.createS2CPacket(payload);
    }

    public static PacketSender getSender(class_8610 handler) {
        Objects.requireNonNull(handler, "Server configuration network handler cannot be null");
        return ServerNetworkingImpl.getAddon(handler);
    }

    public static void send(class_8610 handler, class_8710 payload) {
        Objects.requireNonNull(handler, "Server configuration handler cannot be null");
        Objects.requireNonNull(payload, "Payload cannot be null");
        Objects.requireNonNull(payload.method_56479(), "CustomPayload#getId() cannot return null for payload class: " + String.valueOf(payload.getClass()));
        handler.method_14364(ServerConfigurationNetworking.createS2CPacket(payload));
    }

    public static MinecraftServer getServer(class_8610 handler) {
        Objects.requireNonNull(handler, "Network handler cannot be null");
        return ((ServerCommonNetworkHandlerAccessor)handler).getServer();
    }

    public static boolean isReconfiguring(class_8610 handler) {
        Objects.requireNonNull(handler, "Server configuration network handler cannot be null");
        return ServerNetworkingImpl.getAddon(handler).isReconfiguring();
    }

    private ServerConfigurationNetworking() {
    }

    @FunctionalInterface
    public static interface ConfigurationPacketHandler<T extends class_8710> {
        public void receive(T var1, Context var2);
    }

    @ApiStatus.NonExtendable
    public static interface Context {
        public MinecraftServer server();

        public class_8610 networkHandler();

        public PacketSender responseSender();
    }
}

