/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.networking.server;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.S2CPlayChannelEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.impl.networking.AbstractChanneledNetworkAddon;
import net.fabricmc.fabric.impl.networking.ChannelInfoHolder;
import net.fabricmc.fabric.impl.networking.NetworkingImpl;
import net.fabricmc.fabric.impl.networking.RegistrationPayload;
import net.fabricmc.fabric.impl.networking.server.ServerNetworkingImpl;
import net.minecraft.network.Connection;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;

public final class ServerPlayNetworkAddon
extends AbstractChanneledNetworkAddon<ServerPlayNetworking.PlayPayloadHandler<?>> {
    private final ServerGamePacketListenerImpl handler;
    private final MinecraftServer server;
    private final ServerPlayNetworking.Context context;
    private boolean sentInitialRegisterPacket;
    private boolean requestedReconfigure = false;

    public ServerPlayNetworkAddon(ServerGamePacketListenerImpl handler, Connection connection, MinecraftServer server) {
        super(ServerNetworkingImpl.PLAY, connection, "ServerPlayNetworkAddon for " + String.valueOf(handler.player.getDisplayName()));
        this.handler = handler;
        this.server = server;
        this.context = new ContextImpl(server, handler, this);
        this.registerPendingChannels((ChannelInfoHolder)this.connection, ConnectionProtocol.PLAY);
    }

    @Override
    protected void invokeInitEvent() {
        ((ServerPlayConnectionEvents.Init)ServerPlayConnectionEvents.INIT.invoker()).onPlayInit(this.handler, this.server);
    }

    public void onClientReady() {
        ((ServerPlayConnectionEvents.Join)ServerPlayConnectionEvents.JOIN.invoker()).onPlayReady(this.handler, this, this.server);
        this.sendInitialChannelRegistrationPacket();
        this.sentInitialRegisterPacket = true;
    }

    @Override
    protected boolean isOnReceiveThread() {
        return this.server.packetProcessor().isSameThread();
    }

    @Override
    protected void receive(ServerPlayNetworking.PlayPayloadHandler<?> payloadHandler, CustomPacketPayload payload) {
        payloadHandler.receive(payload, this.context);
    }

    @Override
    protected void schedule(Runnable task) {
        this.handler.player.level().getServer().execute(task);
    }

    @Override
    public Packet<?> createPacket(CustomPacketPayload packet) {
        return ServerPlayNetworking.createS2CPacket(packet);
    }

    @Override
    protected void invokeRegisterEvent(List<Identifier> ids) {
        ((S2CPlayChannelEvents.Register)S2CPlayChannelEvents.REGISTER.invoker()).onChannelRegister(this.handler, this, this.server, ids);
    }

    @Override
    protected void invokeUnregisterEvent(List<Identifier> ids) {
        ((S2CPlayChannelEvents.Unregister)S2CPlayChannelEvents.UNREGISTER.invoker()).onChannelUnregister(this.handler, this, this.server, ids);
    }

    @Override
    protected void handleRegistration(Identifier channelName) {
        RegistrationPayload registrationPayload;
        if (this.sentInitialRegisterPacket && (registrationPayload = this.createRegistrationPayload(RegistrationPayload.REGISTER, Collections.singleton(channelName))) != null) {
            this.sendPacket(registrationPayload);
        }
    }

    @Override
    protected void handleUnregistration(Identifier channelName) {
        RegistrationPayload registrationPayload;
        if (this.sentInitialRegisterPacket && (registrationPayload = this.createRegistrationPayload(RegistrationPayload.UNREGISTER, Collections.singleton(channelName))) != null) {
            this.sendPacket(registrationPayload);
        }
    }

    @Override
    protected void invokeDisconnectEvent() {
        ((ServerPlayConnectionEvents.Disconnect)ServerPlayConnectionEvents.DISCONNECT.invoker()).onPlayDisconnect(this.handler, this.server);
    }

    @Override
    protected boolean isReservedChannel(Identifier channelName) {
        return NetworkingImpl.isReservedCommonChannel(channelName);
    }

    public void reconfigure() {
        if (this.requestedReconfigure) {
            throw new IllegalStateException("Already requested reconfigure");
        }
        this.requestedReconfigure = true;
        this.handler.switchToConfig();
    }

    public boolean requestedReconfigure() {
        return this.requestedReconfigure;
    }

    private record ContextImpl(MinecraftServer server, ServerGamePacketListenerImpl handler, PacketSender responseSender) implements ServerPlayNetworking.Context
    {
        private ContextImpl {
            Objects.requireNonNull(server, "server");
            Objects.requireNonNull(handler, "handler");
            Objects.requireNonNull(responseSender, "responseSender");
        }

        @Override
        public ServerPlayer player() {
            return this.handler.getPlayer();
        }
    }
}

